/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.VisualizerParameterizer;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Alias(value={"de.lmu.ifi.dbs.elki.visualization.ExportVisualizations"})
public class ExportVisualizations
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ExportVisualizations.class);
    File output;
    VisualizerParameterizer manager;
    double ratio;
    Result baseResult = null;
    VisualizerContext context = null;
    Map<String, Integer> counter = new HashMap<String, Integer>();
    Format format;
    int iwidth;

    public ExportVisualizations(File output, VisualizerParameterizer manager, double ratio, Format format) {
        this(output, manager, ratio, format, 1000);
    }

    public ExportVisualizations(File output, VisualizerParameterizer manager, double ratio, Format format, int iwidth) {
        this.output = output;
        this.manager = manager;
        this.ratio = ratio;
        this.format = format;
        this.iwidth = iwidth;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        if (this.output.isFile()) {
            throw new AbortException("Output folder cannot be an existing file.");
        }
        if (!this.output.exists() && !this.output.mkdirs()) {
            throw new AbortException("Could not create output directory.");
        }
        if (this.baseResult == null) {
            this.baseResult = newResult;
            this.context = null;
            this.counter = new HashMap<String, Integer>();
            LOG.warning("Note: Reusing visualization exporter for more than one result is untested.");
        }
        if (this.context == null) {
            this.context = this.manager.newContext(hier, this.baseResult);
        }
        VisualizationTree vistree = this.context.getVisHierarchy();
        It<VisualizationItem> iter2 = vistree.iterAll().filter(Projector.class);
        while (iter2.valid()) {
            Collection<PlotItem> items = iter2.get().arrange(this.context);
            for (PlotItem item : items) {
                this.processItem(item);
            }
            iter2.advance();
        }
        iter2 = vistree.iterAll().filter(VisualizationTask.class);
        while (iter2.valid()) {
            VisualizationTask task = (VisualizationTask)iter2.get();
            if (!vistree.iterParents(task).filter(Projector.class).valid()) {
                PlotItem pi = new PlotItem(this.ratio, 1.0, null);
                pi.add(task);
                this.processItem(pi);
            }
            iter2.advance();
        }
    }

    private void processItem(PlotItem item) {
        Iterator<PlotItem> iter = item.subitems.iterator();
        while (iter.hasNext()) {
            this.processItem(iter.next());
        }
        if (item.taskSize() <= 0) {
            return;
        }
        item.sort();
        double width = item.w;
        double height = item.h;
        VisualizationPlot svgp = new VisualizationPlot();
        svgp.getRoot().setAttribute("width", "20cm");
        svgp.getRoot().setAttribute("height", 20.0 * height / width + "cm");
        svgp.getRoot().setAttribute("viewBox", "0 0 " + width + " " + height);
        ArrayList<Visualization> layers = new ArrayList<Visualization>();
        for (VisualizationTask task : item.tasks) {
            if (task.has(VisualizationTask.RenderFlag.NO_DETAIL) || task.has(VisualizationTask.RenderFlag.NO_EXPORT) || !task.isVisible()) continue;
            try {
                Visualization v = task.getFactory().makeVisualization(this.context, task, svgp, width, height, item.proj);
                layers.add(v);
            }
            catch (Exception e) {
                if (Logging.getLogger(task.getFactory().getClass()).isDebugging()) {
                    LOG.exception("Visualization failed.", e);
                    continue;
                }
                LOG.warning("Visualizer " + task.getFactory().getClass().getName() + " failed - enable debugging to see details.");
            }
        }
        if (layers.isEmpty()) {
            return;
        }
        for (Visualization layer : layers) {
            if (layer.getLayer() == null) {
                LOG.warning("NULL layer seen.");
                continue;
            }
            svgp.getRoot().appendChild(layer.getLayer());
        }
        svgp.updateStyleElement();
        String prefix = null;
        prefix = prefix == null && item.proj != null ? item.proj.getMenuName() : prefix;
        prefix = prefix == null && item.tasks.size() > 0 ? item.tasks.get(0).getMenuName() : prefix;
        prefix = prefix != null ? prefix : "plot";
        Integer count = this.counter.get(prefix);
        count = count == null ? 1 : count + 1;
        this.counter.put(prefix, count);
        try {
            switch (this.format) {
                case SVG: {
                    File outname = new File(this.output, prefix + "-" + count + ".svg");
                    svgp.saveAsSVG(outname);
                    break;
                }
                case PNG: {
                    File outname = new File(this.output, prefix + "-" + count + ".png");
                    svgp.saveAsPNG(outname, (int)((double)this.iwidth * this.ratio), this.iwidth);
                    break;
                }
                case PDF: {
                    File outname = new File(this.output, prefix + "-" + count + ".pdf");
                    svgp.saveAsPDF(outname);
                    break;
                }
                case PS: {
                    File outname = new File(this.output, prefix + "-" + count + ".ps");
                    svgp.saveAsPS(outname);
                    break;
                }
                case EPS: {
                    File outname = new File(this.output, prefix + "-" + count + ".eps");
                    svgp.saveAsEPS(outname);
                    break;
                }
                case JPEG: {
                    File outname = new File(this.output, prefix + "-" + count + ".jpg");
                    svgp.saveAsJPEG(outname, (int)((double)this.iwidth * this.ratio), this.iwidth);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.warning("Export of visualization failed.", e);
        }
        for (Visualization layer : layers) {
            layer.destroy();
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RATIO_ID = new OptionID("vis.ratio", "The width/heigh ratio of the output.");
        public static final OptionID FOLDER_ID = new OptionID("vis.output", "The output folder.");
        public static final OptionID FORMAT_ID = new OptionID("vis.format", "File format. Note that some formats requrie additional libraries, only SVG and PNG are default.");
        public static final OptionID IWIDTH_ID = new OptionID("vis.width", "Image width for pixel formats.");
        VisualizerParameterizer manager;
        File output;
        double ratio;
        Format format;
        int iwidth = 1000;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter iwidthP;
            EnumParameter<Format> formatP;
            DoubleParameter ratioP;
            super.makeOptions(config);
            FileParameter outputP = new FileParameter(FOLDER_ID, FileParameter.FileType.OUTPUT_FILE);
            if (config.grab(outputP)) {
                this.output = (File)outputP.getValue();
            }
            if (config.grab(ratioP = (DoubleParameter)new DoubleParameter(RATIO_ID, 1.33).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.ratio = ratioP.doubleValue();
            }
            if (config.grab(formatP = new EnumParameter<Format>(FORMAT_ID, Format.class, Format.SVG))) {
                this.format = (Format)((Object)formatP.getValue());
            }
            if ((this.format == Format.PNG || this.format == Format.JPEG) && config.grab(iwidthP = new IntParameter(IWIDTH_ID, 1000))) {
                this.iwidth = iwidthP.intValue();
            }
            this.manager = config.tryInstantiate(VisualizerParameterizer.class);
        }

        @Override
        protected ExportVisualizations makeInstance() {
            return new ExportVisualizations(this.output, this.manager, this.ratio, this.format, this.iwidth);
        }
    }

    public static enum Format {
        SVG,
        PNG,
        PDF,
        PS,
        EPS,
        JPEG;

    }
}

