/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.util.List;

public class FrequentItemsetsResult
extends BasicResult
implements TextWriteable {
    private List<Itemset> itemsets;
    private VectorFieldTypeInformation<BitVector> meta;
    private int total;

    public FrequentItemsetsResult(String name, String shortname, List<Itemset> itemsets, VectorFieldTypeInformation<BitVector> meta, int total) {
        super(name, shortname);
        this.itemsets = itemsets;
        this.meta = meta;
        this.total = total;
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        StringBuilder buf = new StringBuilder();
        for (Itemset itemset : this.itemsets) {
            buf.setLength(0);
            out.inlinePrintNoQuotes(itemset.appendTo(buf, this.meta));
            out.flush();
        }
    }

    public VectorFieldTypeInformation<BitVector> getMeta() {
        return this.meta;
    }

    public int getTotal() {
        return this.total;
    }
}

