/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.FilteredConvexHull2D;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierLinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.jafama.FastMath;

@Reference(authors="Erich Achtert, Ahmed Hettab, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Spatial Outlier Detection: Data, Algorithms, Visualizations", booktitle="Proc. 12th Int. Symp. Spatial and Temporal Databases (SSTD 2011)", url="https://doi.org/10.1007/978-3-642-22922-0_41", bibkey="DBLP:conf/ssd/AchtertHKSZ11")
public class KMLOutputHandler
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(KMLOutputHandler.class);
    private static final int NUMSTYLES = 20;
    File filename;
    OutlierScaling scaling;
    private boolean compat;
    private boolean autoopen;

    public KMLOutputHandler(File filename, OutlierScaling scaling, boolean compat, boolean autoopen) {
        this.filename = filename;
        this.scaling = scaling;
        this.compat = compat;
        this.autoopen = autoopen;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        XMLStreamWriter xmlw;
        ZipOutputStream out;
        XMLOutputFactory factory;
        ArrayList<OutlierResult> ors = ResultUtil.filterResults(hier, newResult, OutlierResult.class);
        ArrayList<Clustering> crs = ResultUtil.filterResults(hier, newResult, Clustering.class);
        if (ors.size() + crs.size() > 1) {
            throw new AbortException("More than one visualizable result found. The KML writer only supports a single result!");
        }
        Database database = ResultUtil.findDatabase(hier);
        for (OutlierResult outlierResult : ors) {
            try {
                factory = XMLOutputFactory.newInstance();
                out = new ZipOutputStream(new FileOutputStream(this.filename));
                out.putNextEntry(new ZipEntry("doc.kml"));
                xmlw = factory.createXMLStreamWriter(out);
                this.writeOutlierResult(xmlw, outlierResult, database);
                xmlw.flush();
                xmlw.close();
                out.closeEntry();
                out.flush();
                out.close();
                if (!this.autoopen) continue;
                Desktop.getDesktop().open(this.filename);
            }
            catch (XMLStreamException e) {
                LOG.exception(e);
                throw new AbortException("XML error in KML output.", e);
            }
            catch (IOException e) {
                LOG.exception(e);
                throw new AbortException("IO error in KML output.", e);
            }
        }
        for (Clustering clusteringResult : crs) {
            try {
                factory = XMLOutputFactory.newInstance();
                out = new ZipOutputStream(new FileOutputStream(this.filename));
                out.putNextEntry(new ZipEntry("doc.kml"));
                xmlw = factory.createXMLStreamWriter(out);
                Clustering cres = clusteringResult;
                this.writeClusteringResult(xmlw, cres, database);
                xmlw.flush();
                xmlw.close();
                out.closeEntry();
                out.flush();
                out.close();
                if (!this.autoopen) continue;
                Desktop.getDesktop().open(this.filename);
            }
            catch (XMLStreamException e) {
                LOG.exception(e);
                throw new AbortException("XML error in KML output.", e);
            }
            catch (IOException e) {
                LOG.exception(e);
                throw new AbortException("IO error in KML output.", e);
            }
        }
    }

    private void writeOutlierResult(XMLStreamWriter xmlw, OutlierResult outlierResult, Database database) throws XMLStreamException {
        Relation polys = database.getRelation(TypeUtil.POLYGON_TYPE, new Object[0]);
        Relation<String> labels = DatabaseUtil.guessObjectLabelRepresentation(database);
        xmlw.writeStartDocument();
        xmlw.writeCharacters("\n");
        xmlw.writeStartElement("kml");
        xmlw.writeDefaultNamespace("http://earth.google.com/kml/2.2");
        xmlw.writeStartElement("Document");
        xmlw.writeStartElement("name");
        xmlw.writeCharacters("ELKI KML output for " + outlierResult.getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        xmlw.writeStartElement("description");
        xmlw.writeCharacters("ELKI KML output for " + outlierResult.getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        for (int i = 0; i < 20; ++i) {
            Color col = KMLOutputHandler.getColorForValue((double)i / 19.0);
            xmlw.writeStartElement("Style");
            xmlw.writeAttribute("id", "s" + i);
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("LineStyle");
            xmlw.writeStartElement("width");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("PolyStyle");
            xmlw.writeStartElement("color");
            xmlw.writeCharacters(String.format("%02x%02x%02x%02x", col.getAlpha(), col.getBlue(), col.getGreen(), col.getRed()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("outline");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
        }
        DoubleRelation scores = outlierResult.getScores();
        LinkedList otherrel = new LinkedList(database.getRelations());
        otherrel.remove(scores);
        otherrel.remove(polys);
        otherrel.remove(labels);
        otherrel.remove(database.getRelation(TypeUtil.DBID, new Object[0]));
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(scores.getDBIDs());
        this.scaling.prepare(outlierResult);
        DBIDArrayMIter iter = outlierResult.getOrdering().order(ids).iter();
        while (iter.valid()) {
            double score = scores.doubleValue(iter);
            PolygonsObject poly = (PolygonsObject)polys.get(iter);
            String label = labels.get(iter);
            if (Double.isNaN(score)) {
                LOG.warning("No score for object " + DBIDUtil.toString(iter));
            }
            if (poly == null) {
                LOG.warning("No polygon for object " + DBIDUtil.toString(iter) + " - skipping.");
            } else {
                xmlw.writeStartElement("Placemark");
                xmlw.writeStartElement("name");
                xmlw.writeCharacters(score + " " + label);
                xmlw.writeEndElement();
                StringBuilder buf = this.makeDescription(otherrel, iter);
                xmlw.writeStartElement("description");
                xmlw.writeCData("<div>" + buf.toString() + "</div>");
                xmlw.writeEndElement();
                xmlw.writeStartElement("styleUrl");
                int style = (int)(this.scaling.getScaled(score) * 20.0);
                style = Math.max(0, Math.min(style, 19));
                xmlw.writeCharacters("#s" + style);
                xmlw.writeEndElement();
                xmlw.writeStartElement("Polygon");
                this.writeNewlineOnDebug(xmlw);
                if (this.compat) {
                    xmlw.writeStartElement("altitudeMode");
                    xmlw.writeCharacters("relativeToGround");
                    xmlw.writeEndElement();
                    this.writeNewlineOnDebug(xmlw);
                }
                boolean first = true;
                for (Polygon p : poly.getPolygons()) {
                    if (first) {
                        xmlw.writeStartElement("outerBoundaryIs");
                    } else {
                        xmlw.writeStartElement("innerBoundaryIs");
                    }
                    xmlw.writeStartElement("LinearRing");
                    xmlw.writeStartElement("coordinates");
                    boolean reverse = p.testClockwise() >= 0;
                    ArrayListIter<double[]> it = p.iter();
                    if (reverse) {
                        it.seek(p.size() - 1);
                    }
                    while (it.valid()) {
                        double[] v = it.get();
                        xmlw.writeCharacters(FormatUtil.format(v, ","));
                        if (this.compat && v.length == 2) {
                            xmlw.writeCharacters(",50");
                        }
                        xmlw.writeCharacters(" ");
                        if (!reverse) {
                            it.advance();
                            continue;
                        }
                        it.retract();
                    }
                    xmlw.writeEndElement();
                    xmlw.writeEndElement();
                    xmlw.writeEndElement();
                    first = false;
                }
                this.writeNewlineOnDebug(xmlw);
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                this.writeNewlineOnDebug(xmlw);
            }
            iter.advance();
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    private void writeClusteringResult(XMLStreamWriter xmlw, Clustering<Model> clustering, Database database) throws XMLStreamException {
        xmlw.writeStartDocument();
        xmlw.writeCharacters("\n");
        xmlw.writeStartElement("kml");
        xmlw.writeDefaultNamespace("http://earth.google.com/kml/2.2");
        xmlw.writeStartElement("Document");
        xmlw.writeStartElement("name");
        xmlw.writeCharacters("ELKI KML output for " + clustering.getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        xmlw.writeStartElement("description");
        xmlw.writeCharacters("ELKI KML output for " + clustering.getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        List<Cluster<Model>> clusters = clustering.getAllClusters();
        Relation coords = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD_2D, new Object[0]);
        List<Cluster<Model>> topc = clustering.getToplevelClusters();
        Hierarchy<Cluster<Model>> hier = clustering.getClusterHierarchy();
        HashMap<Object, DoubleObjPair<Polygon>> hullmap = new HashMap<Object, DoubleObjPair<Polygon>>();
        for (Cluster<Model> clu : topc) {
            this.buildHullsRecursively(clu, hier, hullmap, coords);
        }
        double projarea = 648.0;
        Iterator<Cluster<Model>> it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster<Model> clus = it.next();
            Color col = Color.getHSBColor((float)i / 4.294967f, 1.0f, 0.5f);
            DoubleObjPair pair = (DoubleObjPair)hullmap.get(clus);
            double hullarea = SpatialUtil.volume((SpatialComparable)pair.second);
            double relativeArea = Math.max(1.0 - hullarea / 648.0, 0.0);
            double opacity = 0.65 * FastMath.sqrt(relativeArea) + 0.1;
            xmlw.writeStartElement("Style");
            xmlw.writeAttribute("id", "s" + i);
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("LineStyle");
            xmlw.writeStartElement("width");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("PolyStyle");
            xmlw.writeStartElement("color");
            xmlw.writeCharacters(String.format("%02x%02x%02x%02x", (int)(255.0 * Math.min(0.75, opacity)), col.getBlue(), col.getGreen(), col.getRed()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("outline");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            ++i;
        }
        Cluster<Model> ignore = topc.size() == 1 ? topc.get(0) : null;
        Iterator<Cluster<Model>> it2 = clusters.iterator();
        int cnum = 0;
        while (it2.hasNext()) {
            Cluster<Model> c = it2.next();
            if (c != ignore) {
                Polygon p = (Polygon)((DoubleObjPair)hullmap.get(c)).second;
                xmlw.writeStartElement("Placemark");
                xmlw.writeStartElement("name");
                xmlw.writeCharacters(c.getNameAutomatic());
                xmlw.writeEndElement();
                xmlw.writeStartElement("description");
                xmlw.writeCData(this.makeDescription(c).toString());
                xmlw.writeEndElement();
                xmlw.writeStartElement("styleUrl");
                xmlw.writeCharacters("#s" + cnum);
                xmlw.writeEndElement();
                xmlw.writeStartElement("Polygon");
                this.writeNewlineOnDebug(xmlw);
                if (this.compat) {
                    xmlw.writeStartElement("altitudeMode");
                    xmlw.writeCharacters("relativeToGround");
                    xmlw.writeEndElement();
                    this.writeNewlineOnDebug(xmlw);
                }
                xmlw.writeStartElement("outerBoundaryIs");
                xmlw.writeStartElement("LinearRing");
                xmlw.writeStartElement("coordinates");
                boolean reverse = p.testClockwise() >= 0;
                ArrayListIter<double[]> itp = p.iter();
                if (reverse) {
                    itp.seek(p.size() - 1);
                }
                while (itp.valid()) {
                    double[] v = itp.get();
                    xmlw.writeCharacters(FormatUtil.format(v, ","));
                    if (this.compat && v.length == 2) {
                        xmlw.writeCharacters(",100");
                    }
                    xmlw.writeCharacters(" ");
                    if (!reverse) {
                        itp.advance();
                        continue;
                    }
                    itp.retract();
                }
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                this.writeNewlineOnDebug(xmlw);
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                this.writeNewlineOnDebug(xmlw);
            }
            ++cnum;
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    private DoubleObjPair<Polygon> buildHullsRecursively(Cluster<Model> clu, Hierarchy<Cluster<Model>> hier, Map<Object, DoubleObjPair<Polygon>> hulls, Relation<? extends NumberVector> coords) {
        int numc;
        DBIDs ids = clu.getIDs();
        FilteredConvexHull2D hull = new FilteredConvexHull2D();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            hull.add(coords.get(iter).toArray());
            iter.advance();
        }
        double weight = ids.size();
        if (hier != null && (numc = hier.numChildren(clu)) > 0) {
            It<Cluster<Model>> iter2 = hier.iterChildren(clu);
            while (iter2.valid()) {
                Cluster<Model> iclu = iter2.get();
                DoubleObjPair<Polygon> poly = hulls.get(iclu);
                if (poly == null) {
                    poly = this.buildHullsRecursively(iclu, hier, hulls, coords);
                }
                ArrayListIter<double[]> vi = ((Polygon)poly.second).iter();
                while (vi.valid()) {
                    hull.add(vi.get());
                    vi.advance();
                }
                weight += poly.first / (double)numc;
                iter2.advance();
            }
        }
        DoubleObjPair<Polygon> pair = new DoubleObjPair<Polygon>(weight, hull.getHull());
        hulls.put(clu, pair);
        return pair;
    }

    private StringBuilder makeDescription(Collection<Relation<?>> relations, DBIDRef id) {
        StringBuilder buf = new StringBuilder();
        for (Relation<?> rel : relations) {
            String s;
            Object o = rel.get(id);
            if (o == null || (s = o.toString()) == null) continue;
            if (buf.length() > 0) {
                buf.append("<br />");
            }
            buf.append(s);
        }
        return buf;
    }

    private StringBuilder makeDescription(Cluster<?> c) {
        return new StringBuilder(200).append("<div>").append(c.getNameAutomatic()).append("<br />").append("Size: ").append(c.size()).append("</div>");
    }

    private void writeNewlineOnDebug(XMLStreamWriter out) throws XMLStreamException {
        if (LOG.isDebugging()) {
            out.writeCharacters("\n");
        }
    }

    public static final Color getColorForValue(double val) {
        double[] pos = new double[]{0.0, 0.6, 0.8, 1.0};
        Color[] cols = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 1.0f, 0.8f), new Color(1.0f, 0.0f, 0.0f, 0.9f), new Color(1.0f, 1.0f, 0.0f, 1.0f)};
        assert (pos.length == cols.length);
        if (val < pos[0]) {
            val = pos[0];
        }
        for (int i = 1; i < pos.length; ++i) {
            if (!(val <= pos[i])) continue;
            Color prev = cols[i - 1];
            Color next = cols[i];
            double mix = (val - pos[i - 1]) / (pos[i] - pos[i - 1]);
            int r = (int)((1.0 - mix) * (double)prev.getRed() + mix * (double)next.getRed());
            int g = (int)((1.0 - mix) * (double)prev.getGreen() + mix * (double)next.getGreen());
            int b = (int)((1.0 - mix) * (double)prev.getBlue() + mix * (double)next.getBlue());
            int a = (int)((1.0 - mix) * (double)prev.getAlpha() + mix * (double)next.getAlpha());
            Color col = new Color(r, g, b, a);
            return col;
        }
        return cols[cols.length - 1];
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SCALING_ID = new OptionID("kml.scaling", "Additional scaling function for KML colorization.");
        public static final OptionID COMPAT_ID = new OptionID("kml.compat", "Use simpler KML objects, compatibility mode.");
        public static final OptionID AUTOOPEN_ID = new OptionID("kml.autoopen", "Automatically open the result file.");
        File filename;
        OutlierScaling scaling;
        boolean compat;
        boolean autoopen = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag autoopenF;
            Flag compatF;
            ObjectParameter scalingP;
            super.makeOptions(config);
            FileParameter outputP = new FileParameter(OutputStep.Parameterizer.OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE);
            outputP.setShortDescription("Filename the KMZ file (compressed KML) is written to.");
            if (config.grab(outputP)) {
                this.filename = (File)outputP.getValue();
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, (Class<?>)OutlierScaling.class, OutlierLinearScaling.class))) {
                this.scaling = (OutlierScaling)scalingP.instantiateClass(config);
            }
            if (config.grab(compatF = new Flag(COMPAT_ID))) {
                this.compat = (Boolean)compatF.getValue();
            }
            if (config.grab(autoopenF = new Flag(AUTOOPEN_ID))) {
                this.autoopen = (Boolean)autoopenF.getValue();
            }
        }

        @Override
        protected KMLOutputHandler makeInstance() {
            return new KMLOutputHandler(this.filename, this.scaling, this.compat, this.autoopen);
        }
    }
}

