/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;

@Description(value="Development result handler that merely logs the structure of the result tree.")
public class LogResultStructureResultHandler
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(LogResultStructureResultHandler.class);

    @Override
    public void processNewResult(ResultHierarchy hier, Result newResult) {
        if (LOG.isVerbose()) {
            StringBuilder buf = new StringBuilder();
            this.recursiveLogResult(buf, hier, newResult, 0);
            LOG.verbose(buf.toString());
        }
    }

    private void recursiveLogResult(StringBuilder buf, Hierarchy<Result> hier, Result result, int depth) {
        if (result == null) {
            buf.append("null");
            LOG.warning("null result!");
            return;
        }
        if (depth > 50) {
            LOG.warning("Probably infinitely nested results, aborting!");
            return;
        }
        for (int i = 0; i < depth; ++i) {
            buf.append(' ');
        }
        buf.append(result.getClass().getSimpleName()).append(": ").append(result.getLongName()).append(" (").append(result.getShortName()).append(")\n");
        if (hier.numChildren(result) > 0) {
            It<Result> iter = hier.iterChildren(result);
            while (iter.valid()) {
                this.recursiveLogResult(buf, hier, iter.get(), depth + 1);
                iter.advance();
            }
        }
    }
}

