/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import java.util.Comparator;

public class OrderingFromDataStore<T extends Comparable<T>>
extends BasicResult
implements OrderingResult {
    protected DataStore<? extends T> map;
    protected DBIDs ids;
    protected Comparator<T> comparator;
    int ascending;

    public OrderingFromDataStore(String name, String shortname, DBIDs ids, DataStore<? extends T> map, Comparator<T> comparator, boolean descending) {
        super(name, shortname);
        this.map = map;
        this.ids = ids;
        this.comparator = comparator;
        this.ascending = descending ? -1 : 1;
    }

    public OrderingFromDataStore(String name, String shortname, DBIDs ids, DataStore<? extends T> map, boolean descending) {
        super(name, shortname);
        this.map = map;
        this.ids = ids;
        this.comparator = null;
        this.ascending = descending ? -1 : 1;
    }

    public OrderingFromDataStore(String name, String shortname, DBIDs ids, DataStore<? extends T> map) {
        super(name, shortname);
        this.map = map;
        this.ids = ids;
        this.comparator = null;
        this.ascending = 1;
    }

    @Override
    public DBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public ArrayModifiableDBIDs order(DBIDs ids) {
        ArrayModifiableDBIDs sorted = DBIDUtil.newArray(ids);
        if (this.comparator != null) {
            sorted.sort((Comparator<? super DBIDRef>)new Comparator<DBIDRef>(){

                @Override
                public int compare(DBIDRef id1, DBIDRef id2) {
                    Comparable k1 = (Comparable)OrderingFromDataStore.this.map.get(id1);
                    Comparable k2 = (Comparable)OrderingFromDataStore.this.map.get(id2);
                    assert (k1 != null && k2 != null);
                    return OrderingFromDataStore.this.ascending * OrderingFromDataStore.this.comparator.compare(k1, k2);
                }
            });
        } else {
            sorted.sort((Comparator<? super DBIDRef>)new Comparator<DBIDRef>(){

                @Override
                public int compare(DBIDRef id1, DBIDRef id2) {
                    Comparable k1 = (Comparable)OrderingFromDataStore.this.map.get(id1);
                    Comparable k2 = (Comparable)OrderingFromDataStore.this.map.get(id2);
                    assert (k1 != null && k2 != null);
                    return OrderingFromDataStore.this.ascending * k1.compareTo(k2);
                }
            });
        }
        return sorted;
    }
}

