/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import java.util.ArrayList;

public class ResultHierarchy
extends HashMapHierarchy<Result> {
    private static final Logging LOG = Logging.getLogger(ResultHierarchy.class);
    private ArrayList<ResultListener> listenerList = new ArrayList();

    @Override
    public boolean add(Result parent, Result child) {
        boolean changed = super.add(parent, child);
        if (changed && child instanceof HierarchicalResult) {
            HierarchicalResult hr = (HierarchicalResult)child;
            ResultHierarchy h = hr.getHierarchy();
            hr.setHierarchy(this);
            It<HierarchicalResult> iter = h.iterChildren(hr);
            while (iter.valid()) {
                Result desc = iter.get();
                this.add(hr, desc);
                if (desc instanceof HierarchicalResult) {
                    ((HierarchicalResult)desc).setHierarchy(this);
                }
                iter.advance();
            }
        }
        this.fireResultAdded(child, parent);
        return changed;
    }

    @Override
    public boolean remove(Result parent, Result child) {
        boolean changed = super.remove(parent, child);
        this.fireResultRemoved(child, parent);
        return changed;
    }

    public void addResultListener(ResultListener listener) {
        this.listenerList.add(listener);
    }

    public void removeResultListener(ResultListener listener) {
        this.listenerList.remove(listener);
    }

    public void resultChanged(Result res) {
        this.fireResultChanged(res);
    }

    private void fireResultAdded(Result child, Result parent) {
        if (LOG.isDebugging()) {
            LOG.debug("Result added: " + child + " <- " + parent);
        }
        int i = this.listenerList.size();
        while (--i >= 0) {
            this.listenerList.get(i).resultAdded(child, parent);
        }
    }

    private void fireResultChanged(Result current) {
        if (LOG.isDebugging()) {
            LOG.debug("Result changed: " + current);
        }
        int i = this.listenerList.size();
        while (--i >= 0) {
            this.listenerList.get(i).resultChanged(current);
        }
    }

    private void fireResultRemoved(Result child, Result parent) {
        if (LOG.isDebugging()) {
            LOG.debug("Result removed: " + child + " <- " + parent);
        }
        int i = this.listenerList.size();
        while (--i >= 0) {
            this.listenerList.get(i).resultRemoved(child, parent);
        }
    }
}

