/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.IterableResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ResultUtil {
    private ResultUtil() {
    }

    public static List<Relation<?>> getRelations(Result r) {
        if (r instanceof Relation) {
            ArrayList anns = new ArrayList(1);
            anns.add((Relation)r);
            return anns;
        }
        if (r instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)r).getHierarchy(), r, Relation.class);
        }
        return Collections.emptyList();
    }

    public static List<OrderingResult> getOrderingResults(Result r) {
        if (r instanceof OrderingResult) {
            ArrayList<OrderingResult> ors = new ArrayList<OrderingResult>(1);
            ors.add((OrderingResult)r);
            return ors;
        }
        if (r instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)r).getHierarchy(), r, OrderingResult.class);
        }
        return Collections.emptyList();
    }

    public static List<CollectionResult<?>> getCollectionResults(Result r) {
        if (r instanceof CollectionResult) {
            ArrayList crs = new ArrayList(1);
            crs.add((CollectionResult)r);
            return crs;
        }
        if (r instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)r).getHierarchy(), r, CollectionResult.class);
        }
        return Collections.emptyList();
    }

    public static List<IterableResult<?>> getIterableResults(Result r) {
        if (r instanceof IterableResult) {
            ArrayList irs = new ArrayList(1);
            irs.add((IterableResult)r);
            return irs;
        }
        if (r instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)r).getHierarchy(), r, IterableResult.class);
        }
        return Collections.emptyList();
    }

    public static <C extends Result> ArrayList<C> filterResults(ResultHierarchy hier, Result r, Class<? super C> restrictionClass) {
        ArrayList res = new ArrayList();
        It<C> it = hier.iterDescendantsSelf(r).filter(restrictionClass);
        it.forEach(res::add);
        return res;
    }

    public static <C extends Result> ArrayList<C> filterResults(ResultHierarchy hier, Class<? super C> restrictionClass) {
        ArrayList res = new ArrayList();
        It<C> it = hier.iterAll().filter(restrictionClass);
        it.forEach(res::add);
        return res;
    }

    public static void addChildResult(HierarchicalResult parent, Result child) {
        parent.getHierarchy().add(parent, child);
    }

    public static Database findDatabase(ResultHierarchy hier, Result baseResult) {
        ArrayList<Database> dbs = ResultUtil.filterResults(hier, baseResult, Database.class);
        return !dbs.isEmpty() ? (Database)dbs.get(0) : null;
    }

    public static Database findDatabase(ResultHierarchy hier) {
        ArrayList<Database> dbs = ResultUtil.filterResults(hier, Database.class);
        return !dbs.isEmpty() ? (Database)dbs.get(0) : null;
    }

    public static void removeRecursive(ResultHierarchy hierarchy, Result child) {
        It<Result> iter = hierarchy.iterParents(child);
        while (iter.valid()) {
            hierarchy.remove(iter.get(), child);
            iter.advance();
        }
        iter = hierarchy.iterChildren(child);
        while (iter.valid()) {
            ResultUtil.removeRecursive(hierarchy, iter.get());
            iter.advance();
        }
    }
}

