/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.textwriter.MultipleFilesOutput;
import de.lmu.ifi.dbs.elki.result.textwriter.SingleStreamOutput;
import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriter;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

@Priority(value=100)
public class ResultWriter
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ResultWriter.class);
    private File out;
    private boolean gzip = false;
    private boolean warnoverwrite = true;
    private Pattern filter = null;

    public ResultWriter(File out, boolean gzip, boolean warnoverwrite, Pattern filter) {
        this.out = out;
        this.gzip = gzip;
        this.warnoverwrite = warnoverwrite;
        this.filter = filter;
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        TextWriter writer = new TextWriter();
        try (StreamFactory output = this.openStreamFactory();){
            writer.output(ResultUtil.findDatabase(hier), result, output, this.filter);
        }
        catch (IOException e) {
            throw new IllegalStateException("Input/Output error while writing result.", e);
        }
    }

    private StreamFactory openStreamFactory() throws IOException {
        if (this.out == null) {
            return new SingleStreamOutput(this.gzip);
        }
        String ext = FileUtil.getFilenameExtension(this.out);
        if (!(this.out.exists() || "gz".equals(ext) || "csv".equals(ext) || "ascii".equals(ext) || "txt".equals(ext))) {
            LOG.info("Creating output directory: " + this.out);
            this.out.mkdirs();
        }
        if (this.out.isDirectory()) {
            if (this.warnoverwrite && this.out.listFiles().length > 0) {
                LOG.warning("Output directory specified is not empty. Files will be overwritten and old files may be left over.");
            }
            return new MultipleFilesOutput(this.out, this.gzip);
        }
        if (this.warnoverwrite && this.out.exists() && this.out.length() > 0L) {
            LOG.warning("Output file exists and will be overwritten!");
        }
        return new SingleStreamOutput(this.out, this.gzip);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID GZIP_OUTPUT_ID = new OptionID("out.gzip", "Enable gzip compression of output files.");
        public static final OptionID OVERWRITE_OPTION_ID = new OptionID("out.silentoverwrite", "Silently overwrite output files.");
        public static final OptionID FILTER_PATTERN_ID = new OptionID("out.filter", "Filter pattern for output selection. Only output streams that match the given pattern will be written.");
        private File out = null;
        private boolean gzip = false;
        private boolean warnoverwrite = true;
        private Pattern filter = null;

        @Override
        protected void makeOptions(Parameterization config) {
            PatternParameter filterP;
            Flag overwriteF;
            Flag gzipF;
            super.makeOptions(config);
            FileParameter outputP = new FileParameter(OutputStep.Parameterizer.OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE, true);
            if (config.grab(outputP)) {
                this.out = (File)outputP.getValue();
            }
            if (config.grab(gzipF = new Flag(GZIP_OUTPUT_ID))) {
                this.gzip = (Boolean)gzipF.getValue();
            }
            if (config.grab(overwriteF = new Flag(OVERWRITE_OPTION_ID))) {
                boolean bl = this.warnoverwrite = (Boolean)overwriteF.getValue() == false;
            }
            if (config.grab(filterP = (PatternParameter)new PatternParameter(FILTER_PATTERN_ID).setOptional(true))) {
                this.filter = (Pattern)filterP.getValue();
            }
        }

        @Override
        protected ResultWriter makeInstance() {
            return new ResultWriter(this.out, this.gzip, this.warnoverwrite, this.filter);
        }
    }
}

