/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.math.scales.Scales;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import java.util.ArrayList;

public class ScalesResult
extends BasicResult {
    private LinearScale[] scales;

    public ScalesResult(Relation<? extends SpatialComparable> relation) {
        this(Scales.calcScales(relation));
    }

    public ScalesResult(LinearScale[] scales) {
        super("scales", "scales");
        this.scales = scales;
    }

    public LinearScale getScale(int dim) {
        return this.scales[dim - 1];
    }

    public void setScale(int dim, LinearScale scale) {
        this.scales[dim - 1] = scale;
    }

    public LinearScale[] getScales() {
        return this.scales;
    }

    public static ScalesResult getScalesResult(Relation<? extends SpatialComparable> rel) {
        ArrayList<ScalesResult> scas = ResultUtil.filterResults(rel.getHierarchy(), rel, ScalesResult.class);
        if (scas.isEmpty()) {
            ScalesResult newsca = new ScalesResult(rel);
            ResultUtil.addChildResult(rel, newsca);
            return newsca;
        }
        return (ScalesResult)scas.iterator().next();
    }
}

