/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.outlier;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import java.util.Comparator;

public class OrderingFromRelation
implements OrderingResult {
    protected DoubleRelation scores;
    protected boolean ascending = false;

    public OrderingFromRelation(DoubleRelation scores, boolean ascending) {
        this.scores = scores;
        this.ascending = ascending;
    }

    public OrderingFromRelation(DoubleRelation scores) {
        this(scores, false);
    }

    @Override
    public DBIDs getDBIDs() {
        return this.scores.getDBIDs();
    }

    @Override
    public ArrayModifiableDBIDs order(DBIDs ids) {
        ArrayModifiableDBIDs sorted = DBIDUtil.newArray(ids);
        sorted.sort((Comparator<? super DBIDRef>)(this.ascending ? new RelationUtil.AscendingByDoubleRelation(this.scores) : new RelationUtil.DescendingByDoubleRelation(this.scores)));
        return sorted;
    }

    @Override
    public String getLongName() {
        return this.scores.getLongName() + " Order";
    }

    @Override
    public String getShortName() {
        return this.scores.getShortName() + "_order";
    }
}

