/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DBIDsTest;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.OutlierScoreAdapter;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OrderingFromRelation;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OutlierResult
extends BasicResult {
    private OutlierScoreMeta meta;
    private DoubleRelation scores;
    private OrderingResult ordering;

    public OutlierResult(OutlierScoreMeta meta, DoubleRelation scores) {
        super(scores.getLongName(), scores.getShortName());
        this.meta = meta;
        this.scores = scores;
        this.ordering = new OrderingFromRelation(scores, meta instanceof InvertedOutlierScoreMeta);
        this.addChildResult(scores);
        this.addChildResult(this.ordering);
        this.addChildResult(meta);
    }

    public OutlierScoreMeta getOutlierMeta() {
        return this.meta;
    }

    public DoubleRelation getScores() {
        return this.scores;
    }

    public OrderingResult getOrdering() {
        return this.ordering;
    }

    public static List<OutlierResult> getOutlierResults(Result r) {
        if (r instanceof OutlierResult) {
            ArrayList<OutlierResult> ors = new ArrayList<OutlierResult>(1);
            ors.add((OutlierResult)r);
            return ors;
        }
        if (r instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)r).getHierarchy(), r, OutlierResult.class);
        }
        return Collections.emptyList();
    }

    double evaluateBy(ScoreEvaluation eval) {
        return eval.evaluate(new DBIDsTest(DBIDUtil.ensureSet(this.scores.getDBIDs())), new OutlierScoreAdapter(this));
    }
}

