/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;

public class MultipleFilesOutput
implements StreamFactory {
    private static final String EXTENSION = ".txt";
    private static final String GZIP_EXTENSION = ".gz";
    private File basename;
    private boolean usegzip = false;
    private static final Logging LOG = Logging.getLogger(MultipleFilesOutput.class);

    public MultipleFilesOutput(File base) {
        this(base, false);
    }

    public MultipleFilesOutput(File base, boolean gzip) {
        this.basename = base;
        this.usegzip = gzip;
    }

    private PrintStream newStream(String name) throws IOException {
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Requested stream: " + name);
        }
        if (!this.basename.exists()) {
            this.basename.mkdirs();
        }
        String fn = this.basename.getAbsolutePath() + File.separator + name + EXTENSION;
        fn = this.usegzip ? fn + GZIP_EXTENSION : fn;
        OutputStream os = new FileOutputStream(fn);
        if (this.usegzip) {
            os = new GZIPOutputStream(os);
        }
        PrintStream res = new PrintStream(os);
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Opened new output stream:" + fn);
        }
        return res;
    }

    @Override
    public PrintStream openStream(String filename) throws IOException {
        return this.newStream(filename);
    }

    @Override
    public void closeStream(PrintStream stream) {
        stream.close();
    }

    @Override
    public void close() throws IOException {
    }
}

