/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;

public class SingleStreamOutput
implements StreamFactory {
    private PrintStream stream;

    public SingleStreamOutput() throws IOException {
        this(System.out);
    }

    public SingleStreamOutput(boolean gzip) throws IOException {
        this(FileDescriptor.out, gzip);
    }

    public SingleStreamOutput(File out) throws IOException {
        this(new FileOutputStream(out));
    }

    public SingleStreamOutput(File out, boolean gzip) throws IOException {
        this(new FileOutputStream(out), gzip);
    }

    public SingleStreamOutput(FileDescriptor out) throws IOException {
        this(new FileOutputStream(out));
    }

    public SingleStreamOutput(FileDescriptor out, boolean gzip) throws IOException {
        this(new FileOutputStream(out), gzip);
    }

    public SingleStreamOutput(FileOutputStream out) throws IOException {
        this(out, false);
    }

    public SingleStreamOutput(FileOutputStream out, boolean gzip) throws IOException {
        OutputStream os = out;
        if (gzip) {
            os = new GZIPOutputStream(os);
        }
        this.stream = new PrintStream(os);
    }

    public SingleStreamOutput(PrintStream os) {
        this.stream = os;
    }

    @Override
    public PrintStream openStream(String filename) {
        return this.stream;
    }

    @Override
    public void closeStream(PrintStream stream) {
    }

    @Override
    public void close() throws IOException {
        if (this.stream == System.out) {
            this.stream.flush();
            return;
        }
        this.stream.close();
    }
}

