/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.HierarchicalClassLabel;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.ConfusionMatrixEvaluationResult;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.IterableResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterWriterInterface;
import de.lmu.ifi.dbs.elki.result.textwriter.naming.NamingScheme;
import de.lmu.ifi.dbs.elki.result.textwriter.naming.SimpleEnumeratingScheme;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterConfusionMatrixResult;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterDoubleArray;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterDoubleDoublePair;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterIntArray;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterObjectArray;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterObjectComment;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterObjectInline;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterPair;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterTextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterXYCurve;
import de.lmu.ifi.dbs.elki.utilities.HandlerList;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleDoublePair;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TextWriter {
    public static final String FILE_EXTENSION = ".txt";
    public static final HandlerList<TextWriterWriterInterface<?>> writers = new HandlerList();
    protected Map<String, Object> filenames = new HashMap<String, Object>();
    private TextWriterWriterInterface<?> fallback = new TextWriterObjectComment();

    protected String getFilename(Object result, String filenamepre) {
        if (filenamepre == null || filenamepre.length() == 0) {
            filenamepre = "result";
        }
        int i = 0;
        while (true) {
            String filename;
            Object existing;
            if ((existing = this.filenames.get(filename = i > 0 ? filenamepre + "-" + i : filenamepre)) == null || existing == result) {
                this.filenames.put(filename, result);
                return filename;
            }
            ++i;
        }
    }

    public void output(Database db, Result r, StreamFactory streamOpener, Pattern filter) throws IOException {
        LinkedList ra = new LinkedList();
        LinkedList<OrderingResult> ro = new LinkedList<OrderingResult>();
        LinkedList<Clustering> rc = new LinkedList<Clustering>();
        LinkedList<IterableResult> ri = new LinkedList<IterableResult>();
        LinkedList<SettingsResult> rs = new LinkedList<SettingsResult>();
        LinkedList<Result> otherres = new LinkedList<Result>();
        ArrayList<Result> results = ResultUtil.filterResults(db.getHierarchy(), r, Result.class);
        for (Result res : results) {
            String nam;
            if (filter != null && ((nam = res.getShortName()) == null || !filter.matcher(nam).find()) || res instanceof Database) continue;
            if (res instanceof Relation) {
                ra.add((Relation)res);
                continue;
            }
            if (res instanceof OrderingResult) {
                ro.add((OrderingResult)res);
                continue;
            }
            if (res instanceof Clustering) {
                rc.add((Clustering)res);
                continue;
            }
            if (res instanceof IterableResult) {
                ri.add((IterableResult)res);
                continue;
            }
            if (res instanceof SettingsResult) {
                rs.add((SettingsResult)res);
                continue;
            }
            otherres.add(res);
        }
        this.writeSettingsResult(streamOpener, rs);
        for (IterableResult rii : ri) {
            this.writeIterableResult(streamOpener, rii);
        }
        for (Clustering c : rc) {
            SimpleEnumeratingScheme naming = new SimpleEnumeratingScheme(c);
            for (Cluster<Model> cluster : c.getAllClusters()) {
                this.writeClusterResult(db, streamOpener, c, cluster, ra, naming);
            }
        }
        for (OrderingResult ror : ro) {
            this.writeOrderingResult(db, streamOpener, ror, ra);
        }
        for (Result otherr : otherres) {
            this.writeOtherResult(streamOpener, otherr);
        }
    }

    private void printObject(TextWriterStream out, Database db, DBIDRef objID, List<Relation<?>> ra) throws IOException {
        SingleObjectBundle bundle = db.getBundle(objID);
        for (int i = 0; i < bundle.metaLength(); ++i) {
            Object obj = bundle.data(i);
            if (obj == null) continue;
            TextWriterWriterInterface<?> owriter = out.getWriterFor(obj);
            if (owriter == null) {
                throw new IOException("No handler for database object itself: " + obj.getClass().getSimpleName());
            }
            String lbl = null;
            if (TypeUtil.DBID.isAssignableFromType(bundle.meta(i))) {
                lbl = "ID";
            }
            owriter.writeObject(out, lbl, obj);
        }
        Collection<Relation<?>> dbrels = db.getRelations();
        if (ra != null) {
            for (Relation<?> a : ra) {
                TextWriterWriterInterface<?> writer;
                if (dbrels.contains(a)) continue;
                String label = a.getShortName();
                Object value = a.get(objID);
                if (value == null || (writer = out.getWriterFor(value)) == null) continue;
                writer.writeObject(out, label, value);
            }
        }
        out.flush();
    }

    private void writeClusterResult(Database db, StreamFactory streamOpener, Clustering<Model> clustering, Cluster<Model> clus, List<Relation<?>> ra, NamingScheme naming) throws FileNotFoundException, IOException {
        It<Cluster<Model>> iter;
        StringBuilder buf;
        String cname = naming.getNameFor(clus);
        String filename = this.filenameFromLabel(cname);
        PrintStream outStream = streamOpener.openStream(this.getFilename(clus, filename));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        out.commentPrintLn("Cluster: " + cname);
        clus.writeToText(out, null);
        if (clustering.getClusterHierarchy().numParents(clus) > 0) {
            buf = new StringBuilder(100).append("Parents:");
            iter = clustering.getClusterHierarchy().iterParents(clus);
            while (iter.valid()) {
                buf.append(' ').append(naming.getNameFor(iter.get()));
                iter.advance();
            }
            out.commentPrintLn(buf.toString());
        }
        if (clustering.getClusterHierarchy().numChildren(clus) > 0) {
            buf = new StringBuilder(100).append("Children:");
            iter = clustering.getClusterHierarchy().iterChildren(clus);
            while (iter.valid()) {
                buf.append(' ').append(naming.getNameFor(iter.get()));
                iter.advance();
            }
            out.commentPrintLn(buf.toString());
        }
        out.flush();
        DBIDIter iter2 = clus.getIDs().iter();
        while (iter2.valid()) {
            this.printObject(out, db, iter2, ra);
            iter2.advance();
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeIterableResult(StreamFactory streamOpener, IterableResult<?> ri) throws IOException {
        Collection<String> hdr;
        PrintStream outStream = streamOpener.openStream(this.getFilename(ri, ri.getShortName()));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        if (ri instanceof CollectionResult && (hdr = ((CollectionResult)ri).getHeader()) != null) {
            for (String header : hdr) {
                out.commentPrintLn(header);
            }
            out.flush();
        }
        for (Object o : ri) {
            TextWriterWriterInterface<?> writer = out.getWriterFor(o);
            if (writer != null) {
                writer.writeObject(out, null, o);
            }
            out.flush();
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeOrderingResult(Database db, StreamFactory streamOpener, OrderingResult or, List<Relation<?>> ra) throws IOException {
        PrintStream outStream = streamOpener.openStream(this.getFilename(or, or.getShortName()));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        DBIDArrayMIter i = or.order(or.getDBIDs()).iter();
        while (i.valid()) {
            this.printObject(out, db, i, ra);
            i.advance();
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeSettingsResult(StreamFactory streamOpener, List<SettingsResult> rs) throws IOException {
        if (rs.isEmpty()) {
            return;
        }
        SettingsResult r = rs.get(0);
        PrintStream outStream = streamOpener.openStream(this.getFilename(r, r.getShortName()));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        out.commentPrintLn("Settings:");
        for (SettingsResult settings : rs) {
            Object last = null;
            for (TrackedParameter setting : settings.getSettings()) {
                String name;
                if (setting.getOwner() != last && setting.getOwner() != null) {
                    if (last != null) {
                        out.commentPrintLn("");
                    }
                    try {
                        name = setting.getOwner() instanceof Class ? ((Class)setting.getOwner()).getName() : setting.getOwner().getClass().getName();
                        if (ClassParameter.class.isInstance(setting.getOwner())) {
                            name = ((Class)((ClassParameter)setting.getOwner()).getValue()).getName();
                        }
                    }
                    catch (NullPointerException e) {
                        name = "[null]";
                    }
                    out.commentPrintLn(name);
                    last = setting.getOwner();
                }
                name = setting.getParameter().getOptionID().getName();
                String value = "[unset]";
                try {
                    if (setting.getParameter().isDefined()) {
                        value = setting.getParameter().getValueAsString();
                    }
                }
                catch (NullPointerException e) {
                    value = "[null]";
                }
                out.commentPrintLn("-" + name + " " + value);
            }
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeOtherResult(StreamFactory streamOpener, Result r) throws IOException {
        if (writers.getHandler(r) != null) {
            PrintStream outStream = streamOpener.openStream(this.getFilename(r, r.getShortName()));
            TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
            TextWriterWriterInterface<?> owriter = out.getWriterFor(r);
            if (owriter == null) {
                throw new IOException("No handler for result class: " + r.getClass().getSimpleName());
            }
            owriter.writeObject(out, null, r);
            out.flush();
            streamOpener.closeStream(outStream);
        }
    }

    private String filenameFromLabel(String label) {
        return label.toLowerCase().replaceAll("[^a-zA-Z0-9_.\\[\\]-]", "_");
    }

    static {
        TextWriterObjectInline trivialwriter = new TextWriterObjectInline();
        writers.insertHandler(Pair.class, new TextWriterPair());
        writers.insertHandler(DoubleDoublePair.class, new TextWriterDoubleDoublePair());
        writers.insertHandler(FeatureVector.class, trivialwriter);
        writers.insertHandler(double[].class, new TextWriterDoubleArray());
        writers.insertHandler(int[].class, new TextWriterIntArray());
        writers.insertHandler(String.class, trivialwriter);
        writers.insertHandler(Double.class, trivialwriter);
        writers.insertHandler(Integer.class, trivialwriter);
        writers.insertHandler(String[].class, new TextWriterObjectArray());
        writers.insertHandler(Double[].class, new TextWriterObjectArray());
        writers.insertHandler(Integer[].class, new TextWriterObjectArray());
        writers.insertHandler(SimpleClassLabel.class, trivialwriter);
        writers.insertHandler(HierarchicalClassLabel.class, trivialwriter);
        writers.insertHandler(LabelList.class, trivialwriter);
        writers.insertHandler(DBID.class, trivialwriter);
        writers.insertHandler(XYCurve.class, new TextWriterXYCurve());
        writers.insertHandler(TextWriteable.class, new TextWriterTextWriteable());
        writers.insertHandler(ConfusionMatrixEvaluationResult.class, new TextWriterConfusionMatrixResult());
    }
}

