/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterWriterInterface;
import de.lmu.ifi.dbs.elki.utilities.HandlerList;
import java.io.PrintStream;

public class TextWriterStream {
    private PrintStream outStream;
    private StringBuilder inline;
    private StringBuilder comment;
    private HandlerList<TextWriterWriterInterface<?>> writers;
    public static final String SEPARATOR = " ";
    public static final String QUOTE = "# ";
    public static final String COMMENTSEP = "###############################################################";
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String SER_MARKER = "Serialization class:";
    private TextWriterWriterInterface<?> fallbackwriter;

    public TextWriterStream(PrintStream out, HandlerList<TextWriterWriterInterface<?>> writers, TextWriterWriterInterface<?> fallback) {
        this.outStream = out;
        this.writers = writers;
        this.fallbackwriter = fallback;
        this.inline = new StringBuilder();
        this.comment = new StringBuilder();
    }

    public void commentPrint(Object line) {
        this.comment.append(line);
    }

    public void commentPrint(CharSequence line) {
        this.comment.append(line);
    }

    public void commentPrintLn(CharSequence line) {
        this.comment.append(line).append(NEWLINE);
    }

    public void commentPrintLn(Object line) {
        this.comment.append(line).append(NEWLINE);
    }

    public void commentPrintLn() {
        this.comment.append(NEWLINE);
    }

    public void commentPrintSeparator() {
        this.comment.append(COMMENTSEP).append(NEWLINE);
    }

    public void inlinePrint(Object o) {
        if (this.inline.length() > 0) {
            this.inline.append(SEPARATOR);
        }
        String str = o.toString().replace(NEWLINE, SEPARATOR);
        if ((str = str.replace("\\", "\\\\").replace("\"", "\\\"")).contains(SEPARATOR)) {
            this.inline.append('\"').append(str).append('\"');
        } else {
            this.inline.append(str);
        }
    }

    public void inlinePrintNoQuotes(Object o) {
        if (this.inline.length() > 0) {
            this.inline.append(SEPARATOR);
        }
        String str = o.toString().replace(NEWLINE, SEPARATOR);
        str = str.replace("\\", "\\\\").replace("\"", "\\\"");
        this.inline.append(str);
    }

    public void flush() {
        if (this.inline.length() > 0) {
            this.outStream.println(this.inline);
        }
        this.inline.setLength(0);
        if (this.comment.length() > 0) {
            this.quotePrintln(this.outStream, this.comment.toString());
        }
        this.comment.setLength(0);
    }

    private void quotePrintln(PrintStream outStream, String data) {
        String[] lines;
        for (String line : lines = data.split("\n")) {
            if (!line.equals(COMMENTSEP)) {
                outStream.append(QUOTE);
            }
            outStream.append(line).append(NEWLINE);
        }
    }

    public TextWriterWriterInterface<?> getWriterFor(Object o) {
        if (o == null) {
            return null;
        }
        TextWriterWriterInterface<?> writer = this.writers.getHandler(o);
        if (writer != null) {
            return writer;
        }
        try {
            Class<?> decl = o.getClass().getMethod("toString", new Class[0]).getDeclaringClass();
            if (decl == Object.class) {
                return null;
            }
            this.writers.insertHandler(decl, this.fallbackwriter);
            return this.fallbackwriter;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }
}

