/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter.naming;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.result.textwriter.naming.NamingScheme;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;

public class SimpleEnumeratingScheme
implements NamingScheme {
    private Clustering<?> clustering;
    private Object2IntOpenHashMap<String> namefreq = new Object2IntOpenHashMap();
    private Map<Cluster<?>, String> names = new HashMap();
    private static final String NULLPOSTFIX = " 0";

    public SimpleEnumeratingScheme(Clustering<?> clustering) {
        this.clustering = clustering;
        this.updateNames();
    }

    private void updateNames() {
        for (Cluster<?> cluster : this.clustering.getAllClusters()) {
            if (this.names.get(cluster) != null) continue;
            String sugname = cluster.getNameAutomatic();
            int count = this.namefreq.addTo(sugname, 1);
            this.names.put(cluster, sugname + " " + count);
        }
    }

    @Override
    public String getNameFor(Cluster<?> cluster) {
        String basename;
        String nam = this.names.get(cluster);
        if (nam == null) {
            this.updateNames();
            nam = this.names.get(cluster);
        }
        if (nam.endsWith(NULLPOSTFIX) && this.namefreq.getInt(basename = nam.substring(0, nam.length() - NULLPOSTFIX.length())) == 1) {
            nam = basename;
        }
        return nam;
    }
}

