/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter.writers;

import de.lmu.ifi.dbs.elki.evaluation.classification.ConfusionMatrixEvaluationResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterWriterInterface;
import java.io.IOException;

public class TextWriterConfusionMatrixResult
extends TextWriterWriterInterface<ConfusionMatrixEvaluationResult> {
    @Override
    public void write(TextWriterStream out, String label, ConfusionMatrixEvaluationResult eval) throws IOException {
        out.commentPrintLn("Evaluation:");
        out.commentPrintLn(eval.evaluationName);
        out.commentPrintLn("Accuracy: \n  correctly classified instances: ");
        out.commentPrintLn(eval.confusionmatrix.truePositives());
        out.commentPrintLn("true positive rate:         ");
        double tpr = eval.confusionmatrix.truePositiveRate();
        out.commentPrintLn(tpr);
        out.commentPrintLn("false positive rate:        ");
        out.commentPrintLn(eval.confusionmatrix.falsePositiveRate());
        out.commentPrintLn("positive predicted value:   ");
        double ppv = eval.confusionmatrix.positivePredictedValue();
        out.commentPrintLn(ppv);
        out.commentPrintLn("F1-measure:                 ");
        out.commentPrintLn(2.0 * ppv * tpr / (ppv + tpr));
        out.commentPrintLn("\nconfusion matrix:\n");
        out.commentPrintLn(eval.confusionmatrix.toString());
    }
}

