/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ClassInstantiationException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.Parameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.lang.reflect.InvocationTargetException;

public final class ClassGenericsUtil {
    private static final Logging LOG = Logging.getLogger(ClassGenericsUtil.class);
    static final ClassLoader CLASSLOADER = ClassGenericsUtil.class.getClassLoader();
    public static final String FACTORY_METHOD_NAME = "parameterize";

    private ClassGenericsUtil() {
    }

    public static <T> T instantiate(Class<T> type, String className) throws ClassInstantiationException {
        try {
            return type.cast(CLASSLOADER.loadClass(className).newInstance());
        }
        catch (ClassNotFoundException e) {
            try {
                return type.cast(CLASSLOADER.loadClass(type.getPackage().getName() + "." + className).newInstance());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
                throw new ClassInstantiationException(e2);
            }
        }
    }

    public static <T> T instantiateGenerics(Class<?> type, String className) throws ClassInstantiationException {
        try {
            return (T)type.cast(CLASSLOADER.loadClass(className).newInstance());
        }
        catch (ClassNotFoundException e) {
            try {
                return (T)type.cast(CLASSLOADER.loadClass(type.getPackage().getName() + "." + className).newInstance());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
                throw new ClassInstantiationException(e2);
            }
        }
    }

    public static Parameterizer getParameterizer(Class<?> c) {
        for (Class<?> inner : c.getDeclaredClasses()) {
            if (!Parameterizer.class.isAssignableFrom(inner)) continue;
            try {
                return inner.asSubclass(Parameterizer.class).newInstance();
            }
            catch (Exception e) {
                LOG.warning("Non-usable Parameterizer in class: " + c.getName());
            }
        }
        return null;
    }

    public static <C> C tryInstantiate(Class<C> r, Class<?> c, Parameterization config) throws ClassInstantiationException {
        if (c == null) {
            throw new ClassInstantiationException("Trying to instantiate 'null' class!");
        }
        try {
            Parameterizer par = ClassGenericsUtil.getParameterizer(c);
            if (par instanceof AbstractParameterizer) {
                return r.cast(((AbstractParameterizer)par).make(config));
            }
            return r.cast(c.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassInstantiationException(e);
        }
    }

    public static <C> C parameterizeOrAbort(Class<?> c, Parameterization config) {
        try {
            Object ret = ClassGenericsUtil.tryInstantiate(c, c, config);
            if (ret == null) {
                throw new AbortException("Could not instantiate class. Check parameters.");
            }
            return (C)ret;
        }
        catch (Exception e) {
            if (config.hasErrors()) {
                for (ParameterException err : config.getErrors()) {
                    LOG.warning(err.toString());
                }
            }
            throw e instanceof AbortException ? (AbortException)e : new AbortException("Instantiation failed", e);
        }
    }

    public static <D, T extends D> Class<T> uglyCastIntoSubclass(Class<D> cls) {
        return cls;
    }

    public static <BASE, FROM extends BASE, TO extends BASE> Class<TO> uglyCrossCast(Class<FROM> cls, Class<BASE> base) {
        if (!base.isAssignableFrom(cls)) {
            throw cls == null ? new ClassCastException("Attempted to use 'null' as class.") : new ClassCastException(cls.getName() + " is not a superclass of " + base);
        }
        return cls;
    }

    public static <T> T instantiateLowlevel(Class<? extends T> clz) {
        Exception last = null;
        for (Class<?> c : ELKIServiceRegistry.findAllImplementations(clz)) {
            try {
                return clz.cast(c.newInstance());
            }
            catch (Exception e) {
                last = e;
            }
        }
        throw new AbortException("Cannot find a usable implementation of " + clz.toString(), last);
    }
}

