/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;

public final class ELKIBuilder<T> {
    private static final Logging LOG = Logging.getLogger(ELKIBuilder.class);
    private Class<? super T> clazz;
    private ListParameterization p = new ListParameterization();

    public ELKIBuilder(Class<? super T> clazz) {
        this.clazz = clazz;
    }

    public ELKIBuilder<T> with(OptionID opt, Object value) {
        this.p.addParameter(opt, value);
        return this;
    }

    public ELKIBuilder<T> with(OptionID opt) {
        this.p.addFlag(opt);
        return this;
    }

    public ELKIBuilder<T> with(String opt, Object value) {
        this.p.addParameter(opt, value);
        return this;
    }

    public ELKIBuilder<T> with(String opt) {
        this.p.addFlag(opt);
        return this;
    }

    public <C extends T> C build() {
        if (this.p == null) {
            throw new AbortException("build() may be called only once.");
        }
        Object obj = ClassGenericsUtil.parameterizeOrAbort(this.clazz, this.p);
        if (this.p.hasUnusedParameters()) {
            LOG.warning("Unused parameters: " + this.p.getRemainingParameters());
        }
        this.p = null;
        return obj;
    }
}

