/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ELKIServiceScanner {
    private static final Logging LOG = Logging.getLogger(ELKIServiceScanner.class);
    private static final ClassLoader CLASSLOADER = ELKIServiceScanner.class.getClassLoader();
    public static final String FACTORY_POSTFIX = "$Factory";
    private static List<Class<?>> MASTER_CACHE = null;
    public static Comparator<Class<?>> SORT_BY_NAME = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return ELKIServiceScanner.comparePackageClass(o1, o2);
        }
    };
    public static final Comparator<Class<?>> SORT_BY_PRIORITY = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            int c = Integer.compare(ELKIServiceScanner.classPriority(o2), ELKIServiceScanner.classPriority(o1));
            c = c != 0 ? c : ELKIServiceScanner.comparePackageClass(o1, o2);
            return c != 0 ? c : o1.getCanonicalName().compareTo(o2.getCanonicalName());
        }
    };

    private ELKIServiceScanner() {
    }

    public static void load(Class<?> restrictionClass) {
        if (MASTER_CACHE == null) {
            ELKIServiceScanner.initialize();
        }
        if (MASTER_CACHE.isEmpty()) {
            return;
        }
        for (Class<?> clazz : MASTER_CACHE) {
            if (!restrictionClass.isAssignableFrom(clazz) || Modifier.isInterface(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isPrivate(clazz.getModifiers())) continue;
            boolean instantiable = false;
            try {
                instantiable = clazz.getConstructor(new Class[0]) != null;
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            try {
                instantiable = instantiable || ClassGenericsUtil.getParameterizer(clazz) != null;
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            if (!instantiable) continue;
            ELKIServiceRegistry.register(restrictionClass, clazz);
        }
    }

    public static Iterator<Class<?>> nonindexedClasses() {
        if (MASTER_CACHE == null) {
            ELKIServiceScanner.initialize();
        }
        if (MASTER_CACHE.isEmpty()) {
            return Collections.emptyIterator();
        }
        return MASTER_CACHE.iterator();
    }

    private static synchronized void initialize() {
        if (MASTER_CACHE != null) {
            return;
        }
        try {
            Enumeration<URL> cps = CLASSLOADER.getResources("");
            ArrayList res = new ArrayList();
            while (cps.hasMoreElements()) {
                URL u = cps.nextElement();
                if (!"file".equals(u.getProtocol())) continue;
                try {
                    DirClassIterator it = new DirClassIterator(new File(u.toURI()));
                    while (it.hasNext()) {
                        try {
                            Class<?> cls = CLASSLOADER.loadClass((String)it.next());
                            if (cls.getCanonicalName() == null) continue;
                            res.add(cls);
                        }
                        catch (Error | Exception e) {}
                    }
                }
                catch (URISyntaxException e) {
                    LOG.warning("Incorrect classpath entry: " + u);
                }
            }
            MASTER_CACHE = Collections.unmodifiableList(res);
            if (LOG.isDebuggingFinest()) {
                LOG.debugFinest("Classes found by scanning the development classpath: " + MASTER_CACHE.size());
            }
        }
        catch (IOException e) {
            LOG.exception(e);
            return;
        }
    }

    private static int comparePackageClass(Class<?> o1, Class<?> o2) {
        return o1.getPackage() == o2.getPackage() ? o1.getCanonicalName().compareTo(o2.getCanonicalName()) : (o1.getPackage() == null ? -1 : (o2.getPackage() == null ? 1 : o1.getPackage().getName().compareTo(o2.getPackage().getName())));
    }

    private static int classPriority(Class<?> o1) {
        Priority p = o1.getAnnotation(Priority.class);
        if (p == null) {
            Class<?> pa = o1.getDeclaringClass();
            p = pa != null ? pa.getAnnotation(Priority.class) : null;
        }
        return p != null ? p.value() : 0;
    }

    private static class DirClassIterator
    implements Iterator<String> {
        private static final String CLASS_EXT = ".class";
        private static final String FACTORY_FILE_EXT = "$Factory.class";
        private static final int CLASS_EXT_LENGTH = ".class".length();
        private String prefix;
        private ArrayList<String> files = new ArrayList(100);
        private ArrayList<File> folders = new ArrayList(100);

        public DirClassIterator(File path) {
            this.prefix = path.getAbsolutePath();
            if (this.prefix.charAt(this.prefix.length() - 1) != File.separatorChar) {
                this.prefix = this.prefix + File.separatorChar;
            }
            this.folders.add(path);
        }

        @Override
        public boolean hasNext() {
            if (this.files.isEmpty()) {
                this.findNext();
            }
            return !this.files.isEmpty();
        }

        private void findNext() {
            while (!this.folders.isEmpty()) {
                File path = this.folders.remove(this.folders.size() - 1);
                if (!path.isDirectory()) continue;
                for (String localname : path.list()) {
                    if (localname.charAt(0) == '.') continue;
                    if (localname.endsWith(CLASS_EXT)) {
                        if (localname.indexOf(36) >= 0 && !localname.endsWith(FACTORY_FILE_EXT)) continue;
                        String fullname = new File(path, localname).toString();
                        this.files.add(fullname.substring(this.prefix.length(), fullname.length() - CLASS_EXT_LENGTH).replace(File.separatorChar, '.'));
                        continue;
                    }
                    File newf = new File(path, localname);
                    if (!newf.isDirectory()) continue;
                    this.folders.add(newf);
                }
            }
        }

        @Override
        public String next() {
            if (this.files.isEmpty()) {
                this.findNext();
            }
            return !this.files.isEmpty() ? this.files.remove(this.files.size() - 1) : null;
        }
    }
}

