/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.FeatureVectorAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.FloatArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ListArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberListArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberVectorAdapter;
import java.util.List;

public final class ArrayLikeUtil {
    private static final ListArrayAdapter<Object> LISTADAPTER = new ListArrayAdapter();
    private static final NumberListArrayAdapter<Number> NUMBERLISTADAPTER = new NumberListArrayAdapter();
    public static final FeatureVectorAdapter<?> FEATUREVECTORADAPTER = FeatureVectorAdapter.STATIC;
    public static final NumberVectorAdapter NUMBERVECTORADAPTER = NumberVectorAdapter.STATIC;
    public static final NumberArrayAdapter<Double, double[]> DOUBLEARRAYADAPTER = DoubleArrayAdapter.STATIC;
    public static final NumberArrayAdapter<Float, float[]> FLOATARRAYADAPTER = FloatArrayAdapter.STATIC;

    private ArrayLikeUtil() {
    }

    public static <T> ArrayAdapter<T, List<? extends T>> listAdapter(List<? extends T> dummy) {
        return LISTADAPTER;
    }

    public static <T extends Number> NumberArrayAdapter<T, List<? extends T>> numberListAdapter(List<? extends T> dummy) {
        return NUMBERLISTADAPTER;
    }

    public static <F> FeatureVectorAdapter<F> featureVectorAdapter(FeatureVector<F> prototype) {
        return FEATUREVECTORADAPTER;
    }

    public static <A> int getIndexOfMaximum(A array, NumberArrayAdapter<?, A> adapter) throws IndexOutOfBoundsException {
        int size = adapter.size(array);
        int index = 0;
        double max = adapter.getDouble(array, 0);
        for (int i = 1; i < size; ++i) {
            double val = adapter.getDouble(array, i);
            if (!(val > max)) continue;
            max = val;
            index = i;
        }
        return index;
    }

    public static int getIndexOfMaximum(double[] array) throws IndexOutOfBoundsException {
        return ArrayLikeUtil.getIndexOfMaximum(array, DOUBLEARRAYADAPTER);
    }

    public static <A> double[] toPrimitiveDoubleArray(A array, NumberArrayAdapter<?, ? super A> adapter) {
        if (adapter == DOUBLEARRAYADAPTER) {
            return (double[])((double[])array).clone();
        }
        double[] ret = new double[adapter.size(array)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = adapter.getDouble(array, i);
        }
        return ret;
    }

    public static double[] toPrimitiveDoubleArray(List<? extends Number> array) {
        return ArrayLikeUtil.toPrimitiveDoubleArray(array, NUMBERLISTADAPTER);
    }

    public static double[] toPrimitiveDoubleArray(NumberVector obj) {
        return ArrayLikeUtil.toPrimitiveDoubleArray(obj, NUMBERVECTORADAPTER);
    }

    public static <A> float[] toPrimitiveFloatArray(A array, NumberArrayAdapter<?, ? super A> adapter) {
        if (adapter == FLOATARRAYADAPTER) {
            return (float[])((float[])array).clone();
        }
        float[] ret = new float[adapter.size(array)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = adapter.getFloat(array, i);
        }
        return ret;
    }

    public static float[] toPrimitiveFloatArray(List<? extends Number> array) {
        return ArrayLikeUtil.toPrimitiveFloatArray(array, NUMBERLISTADAPTER);
    }

    public static float[] toPrimitiveFloatArray(NumberVector obj) {
        return ArrayLikeUtil.toPrimitiveFloatArray(obj, NUMBERVECTORADAPTER);
    }

    public static <A> int[] toPrimitiveIntegerArray(A array, NumberArrayAdapter<?, ? super A> adapter) {
        int[] ret = new int[adapter.size(array)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = adapter.getInteger(array, i);
        }
        return ret;
    }

    public static int[] toPrimitiveIntegerArray(List<? extends Number> array) {
        return ArrayLikeUtil.toPrimitiveIntegerArray(array, NUMBERLISTADAPTER);
    }

    public static int[] toPrimitiveIntegerArray(NumberVector obj) {
        return ArrayLikeUtil.toPrimitiveIntegerArray(obj, NUMBERVECTORADAPTER);
    }
}

