/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike;

import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;

public class ExtendedArray<T>
implements ArrayAdapter<T, ExtendedArray<T>> {
    final Object array;
    final ArrayAdapter<T, Object> getter;
    final T extra;
    final int size;

    protected ExtendedArray(Object array, ArrayAdapter<T, Object> getter, T extra) {
        this.array = array;
        this.getter = getter;
        this.extra = extra;
        this.size = getter.size(array) + 1;
    }

    @Override
    public int size(ExtendedArray<T> array) {
        assert (this == array);
        return this.size;
    }

    @Override
    public T get(ExtendedArray<T> array, int off) throws IndexOutOfBoundsException {
        assert (this == array);
        if (off == this.size - 1) {
            return this.extra;
        }
        return this.getter.get(this.array, off);
    }

    public static <T, A> ExtendedArray<T> extend(A array, ArrayAdapter<T, A> getter, T extra) {
        return new ExtendedArray<T>(array, getter, extra);
    }
}

