/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arrays;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import it.unimi.dsi.fastutil.ints.IntComparator;

@Reference(authors="V. Yaroslavskiy", title="Dual-Pivot Quicksort", booktitle="", url="http://iaroslavski.narod.ru/quicksort/", bibkey="web/Yaroslavskiy09")
public class IntegerArrayQuickSort {
    private static final int INSERTION_THRESHOLD = 47;

    private IntegerArrayQuickSort() {
    }

    public static void sort(int[] data, IntComparator comp) {
        IntegerArrayQuickSort.sort(data, 0, data.length, comp);
    }

    public static void sort(int[] data, int start, int end, IntComparator comp) {
        IntegerArrayQuickSort.quickSort(data, start, end, comp);
    }

    private static void quickSort(int[] data, int start, int end, IntComparator comp) {
        int len = end - start;
        int last = end - 1;
        if (len < 47) {
            IntegerArrayQuickSort.insertionSort(data, start, end, comp);
            return;
        }
        int seventh = (len >> 3) + (len >> 6) + 1;
        int m3 = start + end >> 1;
        int m2 = m3 - seventh;
        int m1 = m2 - seventh;
        int m4 = m3 + seventh;
        int m5 = m4 + seventh;
        IntegerArrayQuickSort.sort5(data, m1, m2, m3, m4, m5, comp);
        int lpivot = data[m2];
        int rpivot = data[m4];
        data[m2] = data[start];
        data[m4] = data[last];
        boolean tied = comp.compare(lpivot, rpivot) == 0;
        int left = start + 1;
        int right = last - 1;
        for (int k = left; k <= right; ++k) {
            int tmp2;
            int tmp = data[k];
            int c = comp.compare(tmp, lpivot);
            if (c == 0) continue;
            if (c < 0) {
                data[k] = data[left];
                data[left] = tmp;
                ++left;
                continue;
            }
            if (!tied && comp.compare(tmp, rpivot) <= 0) continue;
            while (comp.compare(tmp2 = data[right], rpivot) > 0 && k < right) {
                --right;
            }
            data[k] = data[right];
            data[right] = tmp;
            --right;
            if (comp.compare(data[k], lpivot) >= 0) continue;
            tmp2 = data[k];
            data[k] = data[left];
            data[left] = tmp2;
            ++left;
        }
        data[start] = data[left - 1];
        data[left - 1] = lpivot;
        data[last] = data[right + 1];
        data[right + 1] = rpivot;
        IntegerArrayQuickSort.quickSort(data, start, left - 1, comp);
        if (!tied) {
            IntegerArrayQuickSort.quickSort(data, left, right + 1, comp);
        }
        IntegerArrayQuickSort.quickSort(data, right + 2, end, comp);
    }

    private static void insertionSort(int[] data, int start, int end, IntComparator comp) {
        for (int i = start + 1; i < end; ++i) {
            int pre;
            int cur = data[i];
            for (int j = i - 1; j >= start && comp.compare(cur, pre = data[j]) < 0; --j) {
                data[j + 1] = pre;
            }
            data[j + 1] = cur;
        }
    }

    private static void sort5(int[] data, int m1, int m2, int m3, int m4, int m5, IntComparator comp) {
        int tmp;
        if (comp.compare(data[m1], data[m2]) > 0) {
            tmp = data[m2];
            data[m2] = data[m1];
            data[m1] = tmp;
        }
        if (comp.compare(data[m3], data[m4]) > 0) {
            tmp = data[m4];
            data[m4] = data[m3];
            data[m3] = tmp;
        }
        if (comp.compare(data[m2], data[m4]) > 0) {
            tmp = data[m4];
            data[m4] = data[m2];
            data[m2] = tmp;
        }
        if (comp.compare(data[m1], data[m3]) > 0) {
            tmp = data[m3];
            data[m3] = data[m1];
            data[m1] = tmp;
        }
        if (comp.compare(data[m2], data[m3]) > 0) {
            tmp = data[m3];
            data[m3] = data[m2];
            data[m2] = tmp;
        }
        if (comp.compare(data[m4], tmp = data[m5]) > 0) {
            data[m5] = data[m4];
            data[m4] = tmp;
            if (comp.compare(data[m3], tmp) > 0) {
                data[m4] = data[m3];
                data[m3] = tmp;
                if (comp.compare(data[m2], tmp) > 0) {
                    data[m3] = data[m2];
                    data[m2] = tmp;
                    if (comp.compare(data[m1], tmp) > 0) {
                        data[m2] = data[m1];
                        data[m1] = tmp;
                    }
                }
            }
        }
    }
}

