/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.HeapUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ObjectHeap;
import java.util.Arrays;
import java.util.Comparator;

public class ComparatorMaxHeap<K>
implements ObjectHeap<K> {
    protected Object[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;
    protected Comparator<Object> comparator;

    public ComparatorMaxHeap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.twoheap = new Object[31];
    }

    public ComparatorMaxHeap(int minsize, Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.twoheap = new Object[HeapUtil.nextPow2Int(minsize + 1) - 1];
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(K o) {
        K co = o;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
        }
        int twopos = this.size++;
        this.twoheap[twopos] = co;
        this.heapifyUp(twopos, co);
    }

    @Override
    public void add(K key, int max) {
        if (this.size < max) {
            this.add(key);
        } else if (this.comparator.compare(this.twoheap[0], key) > 0) {
            this.replaceTopElement(key);
        }
    }

    @Override
    public K replaceTopElement(K reinsert) {
        Object ret = this.twoheap[0];
        this.heapifyDown(reinsert);
        return (K)ret;
    }

    private void heapifyUp(int twopos, Object cur) {
        int parent;
        Object par;
        while (twopos > 0 && this.comparator.compare(cur, par = this.twoheap[parent = twopos - 1 >>> 1]) > 0) {
            this.twoheap[twopos] = par;
            twopos = parent;
        }
        this.twoheap[twopos] = cur;
    }

    @Override
    public K poll() {
        Object ret = this.twoheap[0];
        --this.size;
        if (this.size > 0) {
            Object reinsert = this.twoheap[this.size];
            this.twoheap[this.size] = null;
            this.heapifyDown(reinsert);
        } else {
            this.twoheap[0] = null;
        }
        return (K)ret;
    }

    private void heapifyDown(Object cur) {
        int stop = this.size >>> 1;
        int twopos = 0;
        while (twopos < stop) {
            int bestchild = (twopos << 1) + 1;
            Object best = this.twoheap[bestchild];
            int right = bestchild + 1;
            if (right < this.size && this.comparator.compare(best, this.twoheap[right]) < 0) {
                bestchild = right;
                best = this.twoheap[right];
            }
            if (this.comparator.compare(best, cur) <= 0) break;
            this.twoheap[twopos] = best;
            twopos = bestchild;
        }
        this.twoheap[twopos] = cur;
    }

    @Override
    public K peek() {
        return (K)this.twoheap[0];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ComparatorMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter iter = new UnsortedIter();
        while (iter.valid()) {
            buf.append(iter.get()).append(',');
            iter.advance();
        }
        buf.append(']');
        return buf.toString();
    }

    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements ObjectHeap.UnsortedIter<K> {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < ComparatorMaxHeap.this.size;
        }

        @Override
        public UnsortedIter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public K get() {
            return ComparatorMaxHeap.this.twoheap[this.pos];
        }
    }
}

