/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;
import java.util.Comparator;

public class Heap<E> {
    protected Object[] queue;
    protected int size = 0;
    protected final Comparator<Object> comparator;
    private int modCount = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;

    public Heap() {
        this(11, null);
    }

    public Heap(int size) {
        this(size, null);
    }

    public Heap(Comparator<? super E> comparator) {
        this(11, comparator);
    }

    public Heap(int size, Comparator<? super E> comparator) {
        this.queue = new Object[size];
        this.comparator = comparator != null ? comparator : Comparator.naturalOrder();
    }

    public void add(E e) {
        if (this.size + 1 > this.queue.length) {
            this.resize(this.size + 1);
        }
        ++this.size;
        this.heapifyUp(this.size - 1, e);
        this.heapModified();
    }

    public E replaceTopElement(E e) {
        Object oldroot = this.queue[0];
        this.heapifyDown(0, e);
        this.heapModified();
        return (E)oldroot;
    }

    public E peek() {
        return (E)(this.size == 0 ? null : this.queue[0]);
    }

    public E poll() {
        return this.removeAt(0);
    }

    protected E removeAt(int pos) {
        if (pos < 0 || pos >= this.size) {
            return null;
        }
        Object ret = this.queue[pos];
        Object reinsert = this.queue[this.size - 1];
        this.queue[this.size - 1] = null;
        --this.size;
        this.heapifyDown(pos, reinsert);
        this.heapModified();
        return (E)ret;
    }

    protected void heapifyUp(int pos, E elem) {
        int parent;
        Object par;
        assert (pos < this.size && pos >= 0);
        while (pos > 0 && this.comparator.compare(elem, par = this.queue[parent = pos - 1 >>> 1]) < 0) {
            this.queue[pos] = par;
            pos = parent;
        }
        this.queue[pos] = elem;
    }

    protected boolean heapifyDown(int ipos, Object cur) {
        assert (ipos >= 0);
        int pos = ipos;
        int half = this.size >>> 1;
        while (pos < half) {
            Object right;
            int rchild;
            int min = pos;
            Object best = cur;
            int lchild = (pos << 1) + 1;
            Object left = this.queue[lchild];
            if (this.comparator.compare(best, left) > 0) {
                min = lchild;
                best = left;
            }
            if ((rchild = lchild + 1) < this.size && this.comparator.compare(best, right = this.queue[rchild]) > 0) {
                min = rchild;
                best = right;
            }
            if (min == pos) break;
            this.queue[pos] = best;
            pos = min;
        }
        this.queue[pos] = cur;
        return pos != ipos;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected final void resize(int requiredSize) {
        int newCapacity;
        int n = newCapacity = this.queue.length < 64 ? this.queue.length + 1 << 1 : (this.queue.length >> 1) + this.queue.length;
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (requiredSize > newCapacity) {
            newCapacity = requiredSize;
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
        this.heapModified();
    }

    protected void heapModified() {
        ++this.modCount;
    }

    public UnorderedIter unorderedIter() {
        return new UnorderedIter();
    }

    protected String checkHeap() {
        for (int i = 1; i < this.size; ++i) {
            int parent = i - 1 >>> 1;
            if (this.comparator.compare(this.queue[parent], this.queue[i]) <= 0) continue;
            return "@" + parent + ": " + this.queue[parent] + " < @" + i + ": " + this.queue[i];
        }
        return null;
    }

    public class UnorderedIter
    implements Iter {
        int pos = 0;

        protected UnorderedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < Heap.this.size();
        }

        @Override
        public UnorderedIter advance() {
            ++this.pos;
            return this;
        }

        public E get() {
            return Heap.this.queue[this.pos];
        }
    }
}

