/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.HeapUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.IntegerHeap;
import java.util.Arrays;

public class IntegerMaxHeap
implements IntegerHeap {
    protected int[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public IntegerMaxHeap() {
        this.twoheap = new int[31];
    }

    public IntegerMaxHeap(int minsize) {
        this.twoheap = new int[HeapUtil.nextPow2Int(minsize + 1) - 1];
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(int o) {
        int co = o;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
        }
        int twopos = this.size++;
        this.twoheap[twopos] = co;
        this.heapifyUp(twopos, co);
    }

    @Override
    public void add(int key, int max) {
        if (this.size < max) {
            this.add(key);
        } else if (this.twoheap[0] > key) {
            this.replaceTopElement(key);
        }
    }

    @Override
    public int replaceTopElement(int reinsert) {
        int ret = this.twoheap[0];
        this.heapifyDown(reinsert);
        return ret;
    }

    private void heapifyUp(int twopos, int cur) {
        int parent;
        int par;
        while (twopos > 0 && cur > (par = this.twoheap[parent = twopos - 1 >>> 1])) {
            this.twoheap[twopos] = par;
            twopos = parent;
        }
        this.twoheap[twopos] = cur;
    }

    @Override
    public int poll() {
        int ret = this.twoheap[0];
        --this.size;
        if (this.size > 0) {
            int reinsert = this.twoheap[this.size];
            this.twoheap[this.size] = 0;
            this.heapifyDown(reinsert);
        } else {
            this.twoheap[0] = 0;
        }
        return ret;
    }

    private void heapifyDown(int cur) {
        int stop = this.size >>> 1;
        int twopos = 0;
        while (twopos < stop) {
            int bestchild = (twopos << 1) + 1;
            int best = this.twoheap[bestchild];
            int right = bestchild + 1;
            if (right < this.size && best < this.twoheap[right]) {
                bestchild = right;
                best = this.twoheap[right];
            }
            if (best <= cur) break;
            this.twoheap[twopos] = best;
            twopos = bestchild;
        }
        this.twoheap[twopos] = cur;
    }

    @Override
    public int peek() {
        return this.twoheap[0];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(IntegerMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter iter = new UnsortedIter();
        while (iter.valid()) {
            buf.append(iter.get()).append(',');
            iter.advance();
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements IntegerHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < IntegerMaxHeap.this.size;
        }

        @Override
        public UnsortedIter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int get() {
            return IntegerMaxHeap.this.twoheap[this.pos];
        }
    }
}

