/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.HeapUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.IntegerObjectHeap;
import java.util.Arrays;

public class IntegerObjectMaxHeap<V>
implements IntegerObjectHeap<V> {
    protected int[] twoheap;
    protected Object[] twovals;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public IntegerObjectMaxHeap() {
        int[] twoheap = new int[31];
        Object[] twovals = new Object[31];
        this.twoheap = twoheap;
        this.twovals = twovals;
    }

    public IntegerObjectMaxHeap(int minsize) {
        int size = HeapUtil.nextPow2Int(minsize + 1) - 1;
        int[] twoheap = new int[size];
        Object[] twovals = new Object[size];
        this.twoheap = twoheap;
        this.twovals = twovals;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0);
        Arrays.fill(this.twovals, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(int o, V v) {
        int co = o;
        V cv = v;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
            this.twovals = Arrays.copyOf(this.twovals, this.twovals.length + this.twovals.length + 1);
        }
        int twopos = this.size++;
        this.twoheap[twopos] = co;
        this.twovals[twopos] = cv;
        this.heapifyUp(twopos, co, cv);
    }

    @Override
    public void add(int key, V val, int max) {
        if (this.size < max) {
            this.add(key, val);
        } else if (this.twoheap[0] > key) {
            this.replaceTopElement(key, val);
        }
    }

    @Override
    public void replaceTopElement(int reinsert, V val) {
        this.heapifyDown(reinsert, val);
    }

    private void heapifyUp(int twopos, int cur, Object val) {
        int parent;
        int par;
        while (twopos > 0 && cur > (par = this.twoheap[parent = twopos - 1 >>> 1])) {
            this.twoheap[twopos] = par;
            this.twovals[twopos] = this.twovals[parent];
            twopos = parent;
        }
        this.twoheap[twopos] = cur;
        this.twovals[twopos] = val;
    }

    @Override
    public void poll() {
        --this.size;
        if (this.size > 0) {
            int reinsert = this.twoheap[this.size];
            Object reinsertv = this.twovals[this.size];
            this.twoheap[this.size] = 0;
            this.twovals[this.size] = null;
            this.heapifyDown(reinsert, reinsertv);
        } else {
            this.twoheap[0] = 0;
            this.twovals[0] = null;
        }
    }

    private void heapifyDown(int cur, Object val) {
        int stop = this.size >>> 1;
        int twopos = 0;
        while (twopos < stop) {
            int bestchild = (twopos << 1) + 1;
            int best = this.twoheap[bestchild];
            int right = bestchild + 1;
            if (right < this.size && best <= this.twoheap[right]) {
                bestchild = right;
                best = this.twoheap[right];
            }
            if (best <= cur) break;
            this.twoheap[twopos] = best;
            this.twovals[twopos] = this.twovals[bestchild];
            twopos = bestchild;
        }
        this.twoheap[twopos] = cur;
        this.twovals[twopos] = val;
    }

    @Override
    public int peekKey() {
        return this.twoheap[0];
    }

    @Override
    public V peekValue() {
        return (V)this.twovals[0];
    }

    @Override
    public boolean containsKey(int q) {
        for (int pos = 0; pos < this.size; ++pos) {
            if (this.twoheap[pos] != q) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(V q) {
        for (int pos = 0; pos < this.size; ++pos) {
            if (!q.equals(this.twovals[pos])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(IntegerObjectMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter iter = new UnsortedIter();
        while (iter.valid()) {
            buf.append(iter.getKey()).append(':').append(iter.getValue()).append(',');
            iter.advance();
        }
        buf.append(']');
        return buf.toString();
    }

    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements IntegerObjectHeap.UnsortedIter<V> {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < IntegerObjectMaxHeap.this.size;
        }

        @Override
        public UnsortedIter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getKey() {
            return IntegerObjectMaxHeap.this.twoheap[this.pos];
        }

        @Override
        public V getValue() {
            return IntegerObjectMaxHeap.this.twovals[this.pos];
        }
    }
}

