/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TiedTopBoundedHeap<E>
extends TopBoundedHeap<E> {
    private List<E> ties = new ArrayList();

    public TiedTopBoundedHeap(int maxsize, Comparator<? super E> comparator) {
        super(maxsize, comparator);
    }

    public TiedTopBoundedHeap(int maxsize) {
        this(maxsize, null);
    }

    @Override
    public int size() {
        return super.size() + this.ties.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.ties.clear();
    }

    @Override
    public E peek() {
        return this.ties.isEmpty() ? super.peek() : this.ties.get(this.ties.size() - 1);
    }

    @Override
    public E poll() {
        return this.ties.isEmpty() ? super.poll() : this.ties.remove(this.ties.size() - 1);
    }

    @Override
    public E replaceTopElement(E e) {
        if (this.ties.isEmpty()) {
            return super.replaceTopElement(e);
        }
        E prev = this.poll();
        this.add(e);
        return prev;
    }

    @Override
    protected void handleOverflow(E e) {
        if (this.comparator.compare(e, this.queue[0]) == 0) {
            this.ties.add(e);
        } else {
            this.ties.clear();
        }
    }

    @Override
    public UnorderedIter unorderedIter() {
        return new UnorderedIter();
    }

    public class UnorderedIter
    extends Heap.UnorderedIter {
        protected UnorderedIter() {
            super(TiedTopBoundedHeap.this);
        }

        @Override
        public boolean valid() {
            return this.pos < TiedTopBoundedHeap.this.size();
        }

        @Override
        public E get() {
            int ssize = TiedTopBoundedHeap.super.size();
            return this.pos < ssize ? super.get() : TiedTopBoundedHeap.this.ties.get(this.pos - ssize);
        }
    }
}

