/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedUpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TiedTopBoundedUpdatableHeap<E>
extends TopBoundedUpdatableHeap<E> {
    private List<E> ties = new ArrayList();

    public TiedTopBoundedUpdatableHeap(int maxsize, Comparator<? super E> comparator) {
        super(maxsize, comparator);
    }

    public TiedTopBoundedUpdatableHeap(int maxsize) {
        this(maxsize, (Comparator<E>)null);
    }

    @Override
    public int size() {
        return super.size() + this.ties.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.ties.clear();
    }

    @Override
    public void offerAt(int pos, E e) {
        if (pos == -1) {
            Iterator<E> i = this.ties.iterator();
            while (i.hasNext()) {
                E e2 = i.next();
                if (!e.equals(e2)) continue;
                if (this.comparator.compare(e, e2) <= 0) {
                    i.remove();
                    this.index.removeInt(e2);
                }
                return;
            }
            throw new AbortException("Heap corrupt - should not be reached");
        }
        if (pos >= 0 && !this.ties.isEmpty() && this.comparator.compare(e, this.ties.get(0)) < 0) {
            this.removeAt(pos);
            this.index.removeInt(e);
            E e2 = this.ties.remove(this.ties.size() - 1);
            super.offerAt(Integer.MIN_VALUE, e2);
            return;
        }
        super.offerAt(pos, e);
    }

    @Override
    public E peek() {
        return this.ties.isEmpty() ? super.peek() : this.ties.get(this.ties.size() - 1);
    }

    @Override
    public E poll() {
        if (this.ties.isEmpty()) {
            return (E)super.poll();
        }
        E e = this.ties.remove(this.ties.size() - 1);
        this.index.removeInt(e);
        return e;
    }

    @Override
    protected void handleOverflow(E e) {
        if (this.comparator.compare(e, this.queue[0]) == 0) {
            this.ties.add(e);
            this.index.put(e, -1);
        } else {
            this.index.removeInt(e);
            for (E e2 : this.ties) {
                this.index.removeInt(e2);
            }
            this.ties.clear();
        }
    }
}

