/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import java.util.Comparator;

public class TopBoundedHeap<E>
extends Heap<E> {
    protected int maxsize;

    public TopBoundedHeap(int maxsize) {
        this(maxsize, null);
    }

    public TopBoundedHeap(int maxsize, Comparator<? super E> comparator) {
        super(maxsize + 1, comparator);
        this.maxsize = maxsize;
        assert (maxsize > 0);
    }

    @Override
    public void add(E e) {
        if (super.size() < this.maxsize) {
            super.add(e);
            return;
        }
        int comp = this.comparator.compare(e, this.queue[0]);
        if (comp < 0) {
            return;
        }
        if (comp == 0) {
            this.handleOverflow(e);
        } else {
            this.handleOverflow(super.replaceTopElement(e));
        }
    }

    protected void handleOverflow(E e) {
    }

    public int getMaxSize() {
        return this.maxsize;
    }
}

