/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import java.util.Comparator;

public class TopBoundedUpdatableHeap<E>
extends UpdatableHeap<E> {
    protected int maxsize;

    public TopBoundedUpdatableHeap(int maxsize) {
        this(maxsize, (Comparator<E>)null);
    }

    public TopBoundedUpdatableHeap(int maxsize, Comparator<? super E> comparator) {
        super(maxsize + 1, comparator);
        this.maxsize = maxsize;
        assert (maxsize > 0);
    }

    @Override
    public void offerAt(int pos, E e) {
        if (pos != Integer.MIN_VALUE || super.size() < this.maxsize) {
            super.offerAt(pos, e);
            return;
        }
        if (this.comparator.compare(e, this.queue[0]) < 0) {
            return;
        }
        this.handleOverflow(super.replaceTopElement(e));
    }

    protected void handleOverflow(E e) {
    }

    public int getMaxSize() {
        return this.maxsize;
    }
}

