/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;

public class UpdatableHeap<O>
extends Heap<O> {
    protected static final int NO_VALUE = Integer.MIN_VALUE;
    protected static final int IN_TIES = -1;
    protected final Object2IntOpenHashMap<Object> index = new Object2IntOpenHashMap();

    public UpdatableHeap() {
        this.index.defaultReturnValue(Integer.MIN_VALUE);
    }

    public UpdatableHeap(int size) {
        super(size);
        this.index.defaultReturnValue(Integer.MIN_VALUE);
    }

    public UpdatableHeap(Comparator<? super O> comparator) {
        super(comparator);
        this.index.defaultReturnValue(Integer.MIN_VALUE);
    }

    public UpdatableHeap(int size, Comparator<? super O> comparator) {
        super(size, comparator);
        this.index.defaultReturnValue(Integer.MIN_VALUE);
    }

    @Override
    public void clear() {
        super.clear();
        this.index.clear();
    }

    @Override
    public void add(O e) {
        this.offerAt(this.index.getInt(e), e);
    }

    protected void offerAt(int pos, O e) {
        if (pos == Integer.MIN_VALUE) {
            if (this.size + 1 > this.queue.length) {
                this.resize(this.size + 1);
            }
            this.index.put((Object)e, this.size);
            ++this.size;
            this.heapifyUp(this.size - 1, e);
            this.heapModified();
            return;
        }
        assert (pos >= 0) : "Unexpected negative position.";
        assert (this.queue[pos].equals(e));
        if (this.comparator.compare(e, this.queue[pos]) >= 0) {
            return;
        }
        this.heapifyUp(pos, e);
        this.heapModified();
    }

    @Override
    protected O removeAt(int pos) {
        if (pos < 0 || pos >= this.size) {
            return null;
        }
        Object ret = this.queue[pos];
        Object reinsert = this.queue[this.size - 1];
        this.queue[this.size - 1] = null;
        --this.size;
        if (this.comparator.compare(ret, reinsert) > 0) {
            this.heapifyUp(pos, reinsert);
        } else {
            this.heapifyDown(pos, reinsert);
        }
        this.heapModified();
        this.index.removeInt(ret);
        return (O)ret;
    }

    public O removeObject(O e) {
        int pos = this.index.getInt(e);
        return pos >= 0 ? (O)this.removeAt(pos) : null;
    }

    @Override
    public O poll() {
        Object node = super.poll();
        this.index.removeInt(node);
        return (O)node;
    }

    @Override
    public O replaceTopElement(O e) {
        O node = super.replaceTopElement(e);
        this.index.removeInt(node);
        return node;
    }

    @Override
    protected void heapifyUp(int pos, Object cur) {
        int parent;
        Object par;
        while (pos > 0 && this.comparator.compare(cur, par = this.queue[parent = pos - 1 >>> 1]) < 0) {
            this.queue[pos] = par;
            this.index.put(par, pos);
            pos = parent;
        }
        this.queue[pos] = cur;
        this.index.put(cur, pos);
    }

    @Override
    protected boolean heapifyDown(int ipos, Object cur) {
        int pos = ipos;
        int half = this.size >>> 1;
        while (pos < half) {
            Object right;
            int rchild;
            int min = pos;
            Object best = cur;
            int lchild = (pos << 1) + 1;
            Object left = this.queue[lchild];
            if (this.comparator.compare(best, left) > 0) {
                min = lchild;
                best = left;
            }
            if ((rchild = lchild + 1) < this.size && this.comparator.compare(best, right = this.queue[rchild]) > 0) {
                min = rchild;
                best = right;
            }
            if (min == pos) break;
            this.queue[pos] = best;
            this.index.put(best, pos);
            pos = min;
        }
        this.queue[pos] = cur;
        this.index.put(cur, pos);
        return pos != ipos;
    }
}

