/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ObjHistogram;

public abstract class AbstractObjDynamicHistogram<T>
extends ObjHistogram<T> {
    private double[] cacheposs;
    private Object[] cachevals;
    private int cachefill;
    private int destsize;

    public AbstractObjDynamicHistogram(int bins) {
        super(-1, 0.0, 1.0, null);
        this.destsize = bins;
        this.cacheposs = new double[this.destsize << 1];
        this.cachevals = new Object[this.destsize << 1];
        this.cachefill = 0;
        this.supplier = this::makeObject;
    }

    void materialize() {
        if (this.cachefill < 0) {
            return;
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.cachefill; ++i) {
            min = MathUtil.min(min, this.cacheposs[i]);
            max = MathUtil.max(max, this.cacheposs[i]);
        }
        LinearScale scale = new LinearScale(min, max);
        min = scale.getMin();
        max = scale.getMax();
        this.base = min;
        this.max = max;
        this.binsize = (max - min) / (double)this.destsize;
        this.data = new Object[this.destsize << 1];
        for (int i = 0; i < this.destsize; ++i) {
            this.data[i] = this.makeObject();
        }
        this.size = this.destsize;
        int end = this.cachefill;
        this.cachefill = -1;
        for (int i = 0; i < end; ++i) {
            this.putData(this.cacheposs[i], this.cachevals[i]);
        }
        this.cacheposs = null;
        this.cachevals = null;
    }

    @Override
    public T get(double coord) {
        if (this.cachefill >= 0 && this.cachefill < this.cacheposs.length) {
            this.cacheposs[this.cachefill] = coord;
            T t = this.makeObject();
            this.cachevals[this.cachefill++] = t;
            return t;
        }
        this.materialize();
        this.testResample(coord);
        Object ret = super.get(coord);
        return ret;
    }

    public void putData(double coord, T value) {
        if (this.cachefill >= 0 && this.cachefill < this.cacheposs.length) {
            this.cacheposs[this.cachefill] = coord;
            this.cachevals[this.cachefill++] = this.cloneForCache(value);
            return;
        }
        if (coord == Double.NEGATIVE_INFINITY) {
            this.aggregateSpecial(value, 0);
        } else if (coord == Double.POSITIVE_INFINITY) {
            this.aggregateSpecial(value, 1);
        } else if (Double.isNaN(coord)) {
            this.aggregateSpecial(value, 2);
        } else {
            T exist = this.get(coord);
            this.data[this.getBinNr((double)coord)] = this.aggregate(exist, value);
        }
    }

    protected void aggregateSpecial(T value, int bin) {
        Object exist = this.getSpecial(bin);
        this.special[bin] = this.aggregate(exist, value);
    }

    private void testResample(double coord) {
        int off;
        int sizereq;
        int bin = this.getBinNr(coord);
        if (bin < 0) {
            sizereq = this.size - bin;
            off = -bin;
        } else if (bin >= this.data.length) {
            sizereq = bin + 1;
            off = 0;
        } else {
            return;
        }
        if (sizereq < this.data.length) {
            return;
        }
        int levels = BitsUtil.magnitude(sizereq / this.destsize) - 1;
        assert (levels > 0) : "No resampling required?!?";
        int step = 1 << levels;
        int fixpoint = off / (step - 1);
        int oup = fixpoint >= 0 ? fixpoint : 0;
        int inp = (oup << levels) - off;
        assert (-step < inp && inp <= oup && oup < inp + step) : inp + " -> " + oup + " s=" + step + " o=" + off + " l=" + levels;
        while (inp < this.size) {
            assert (oup < inp + step && oup < this.data.length);
            this.data[oup] = this.downsample(this.data, Math.max(0, inp), Math.min(this.size, inp + step), step);
            inp += step;
            ++oup;
        }
        while (oup < this.data.length) {
            this.data[oup] = null;
            ++oup;
        }
        if (off >= step) {
            oup = fixpoint - 1 < this.size ? fixpoint - 1 : this.size - 1;
            inp = (oup << levels) - off;
            assert (oup > inp) : inp + " -> " + oup + " s=" + step + " o=" + off + " l=" + levels;
            while (inp > -step) {
                assert (oup >= inp && oup >= 0);
                this.data[oup] = this.downsample(this.data, Math.max(0, inp), Math.min(this.size, inp + step), step);
                inp -= step;
                --oup;
            }
            while (oup >= 0) {
                this.data[oup] = this.supplier.make();
                --oup;
            }
        }
        this.base -= (double)(this.offset + off) * this.binsize;
        this.offset = 0;
        this.size = this.size + 1 >> levels;
        this.binsize *= (double)(1 << levels);
        this.max = this.base + this.binsize * (double)this.size;
    }

    @Override
    public ObjHistogram.Iter iter() {
        this.materialize();
        return super.iter();
    }

    @Override
    public int getNumBins() {
        this.materialize();
        return super.getNumBins();
    }

    @Override
    public double getBinsize() {
        this.materialize();
        return super.getBinsize();
    }

    @Override
    public double getCoverMinimum() {
        this.materialize();
        return super.getCoverMinimum();
    }

    @Override
    public double getCoverMaximum() {
        this.materialize();
        return super.getCoverMaximum();
    }

    protected abstract T downsample(Object[] var1, int var2, int var3, int var4);

    protected abstract T aggregate(T var1, T var2);

    protected abstract T cloneForCache(T var1);

    protected abstract T makeObject();
}

