/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.Histogram;

public abstract class AbstractStaticHistogram
implements Histogram {
    protected int offset = 0;
    protected int size;
    protected double base;
    protected double max;
    protected double binsize;

    public AbstractStaticHistogram(int bins, double min, double max) {
        this.base = min;
        this.max = max;
        this.binsize = (max - min) / (double)bins;
        this.size = bins;
    }

    protected int getBinNr(double coord) {
        if (Double.isInfinite(coord) || Double.isNaN(coord)) {
            throw new UnsupportedOperationException("Encountered non-finite value in Histogram: " + coord);
        }
        if (coord == this.max) {
            return this.size - 1;
        }
        return (int)Math.floor((coord - this.base) / this.binsize) + this.offset;
    }

    protected static int growSize(int current, int requiredSize) {
        int newCapacity;
        int n = newCapacity = current < 64 ? current + 1 << 1 : (current >> 1) * 3;
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (requiredSize > newCapacity) {
            newCapacity = requiredSize;
        }
        return requiredSize;
    }

    @Override
    public int getNumBins() {
        return this.size;
    }

    @Override
    public double getBinsize() {
        return this.binsize;
    }

    @Override
    public double getCoverMinimum() {
        return this.base - (double)this.offset * this.binsize;
    }

    @Override
    public double getCoverMaximum() {
        return this.base + (double)(this.size - this.offset) * this.binsize;
    }

    @Override
    public abstract Iter iter();

    public abstract class Iter
    implements Histogram.Iter {
        int bin = 0;

        @Override
        public double getCenter() {
            return AbstractStaticHistogram.this.base + ((double)this.bin + 0.5 - (double)AbstractStaticHistogram.this.offset) * AbstractStaticHistogram.this.binsize;
        }

        @Override
        public double getLeft() {
            return AbstractStaticHistogram.this.base + (double)(this.bin - AbstractStaticHistogram.this.offset) * AbstractStaticHistogram.this.binsize;
        }

        @Override
        public double getRight() {
            return AbstractStaticHistogram.this.base + (double)(this.bin + 1 - AbstractStaticHistogram.this.offset) * AbstractStaticHistogram.this.binsize;
        }

        @Override
        public boolean valid() {
            return this.bin >= 0 && this.bin < AbstractStaticHistogram.this.size;
        }

        @Override
        public Iter advance() {
            ++this.bin;
            return this;
        }

        @Override
        public int getOffset() {
            return this.bin;
        }

        @Override
        public Iter advance(int count) {
            this.bin += count;
            return this;
        }

        @Override
        public Iter retract() {
            --this.bin;
            return this;
        }

        @Override
        public Iter seek(int off) {
            this.bin = off;
            return this;
        }
    }
}

