/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.DoubleHistogram;

public class DoubleDynamicHistogram
extends DoubleHistogram {
    private double[] cachec;
    private double[] cachev;
    private int cachefill;
    private int destsize;

    public DoubleDynamicHistogram(int bins) {
        super(-1, 0.0, 1.0);
        this.destsize = bins;
        this.cachec = new double[this.destsize << 2];
        this.cachev = new double[this.destsize << 2];
        this.cachefill = 0;
    }

    void materialize() {
        if (this.cachefill < 0) {
            return;
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.cachefill; ++i) {
            min = Math.min(min, this.cachec[i]);
            max = Math.max(max, this.cachec[i]);
        }
        LinearScale scale = new LinearScale(min, max);
        min = scale.getMin();
        max = scale.getMax();
        this.base = min;
        this.max = max;
        this.binsize = (max - min) / (double)this.destsize;
        this.data = new double[this.destsize << 1];
        this.size = this.destsize;
        int end = this.cachefill;
        this.cachefill = -1;
        for (int i = 0; i < end; ++i) {
            this.increment(this.cachec[i], this.cachev[i]);
        }
        this.cachec = null;
        this.cachev = null;
    }

    @Override
    public double get(double coord) {
        this.materialize();
        this.testResample(coord);
        return super.get(coord);
    }

    @Override
    public void increment(double coord, double value) {
        if (this.cachefill >= 0) {
            if (this.cachefill < this.cachec.length) {
                this.cachec[this.cachefill] = coord;
                this.cachev[this.cachefill] = value;
                ++this.cachefill;
                return;
            }
            this.materialize();
        }
        this.testResample(coord);
        super.increment(coord, value);
    }

    private void testResample(double coord) {
        int off;
        int sizereq;
        int bin = this.getBinNr(coord);
        if (bin < 0) {
            sizereq = this.size - bin;
            off = -bin;
        } else if (bin >= this.data.length) {
            sizereq = bin + 1;
            off = 0;
        } else {
            return;
        }
        if (sizereq < this.data.length) {
            return;
        }
        int levels = BitsUtil.magnitude(sizereq / this.destsize) - 1;
        assert (levels > 0) : "No resampling required?!? sizereq=" + sizereq + " destsize=" + this.destsize + " array=" + this.data.length;
        int step = 1 << levels;
        int fixpoint = off / (step - 1);
        int oup = fixpoint >= 0 ? fixpoint : 0;
        int inp = (oup << levels) - off;
        assert (-step < inp && inp <= oup && oup < inp + step) : inp + " -> " + oup + " s=" + step + " o=" + off + " l=" + levels;
        while (inp < this.size) {
            assert (oup < inp + step && oup < this.data.length);
            this.data[oup] = this.downsample(this.data, Math.max(0, inp), Math.min(this.size, inp + step), step);
            inp += step;
            ++oup;
        }
        while (oup < this.data.length) {
            this.data[oup] = 0.0;
            ++oup;
        }
        if (off >= step) {
            oup = fixpoint - 1 < this.size ? fixpoint - 1 : this.size - 1;
            inp = (oup << levels) - off;
            assert (oup > inp) : inp + " -> " + oup + " s=" + step + " o=" + off + " l=" + levels;
            while (inp > -step) {
                assert (oup >= inp && oup >= 0);
                this.data[oup] = this.downsample(this.data, Math.max(0, inp), Math.min(this.size, inp + step), step);
                inp -= step;
                --oup;
            }
            while (oup >= 0) {
                this.data[oup] = 0.0;
                --oup;
            }
        }
        this.base -= (double)(this.offset + off) * this.binsize;
        this.offset = 0;
        this.size = this.size + 1 >> levels;
        this.binsize *= (double)(1 << levels);
        this.max = this.base + this.binsize * (double)this.size;
    }

    @Override
    public DoubleHistogram.Iter iter() {
        this.materialize();
        return super.iter();
    }

    @Override
    public int getNumBins() {
        this.materialize();
        return super.getNumBins();
    }

    @Override
    public double getBinsize() {
        this.materialize();
        return super.getBinsize();
    }

    @Override
    public double getCoverMinimum() {
        this.materialize();
        return super.getCoverMinimum();
    }

    @Override
    public double getCoverMaximum() {
        this.materialize();
        return super.getCoverMaximum();
    }

    protected double downsample(double[] data, int start, int end, int size) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            sum += data[i];
        }
        return sum;
    }
}

