/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.Histogram;
import java.util.Arrays;

public class DoubleHistogram
extends AbstractStaticHistogram {
    double[] data;

    public DoubleHistogram(int bins, double min, double max) {
        super(bins, min, max);
        this.data = bins >= 0 ? new double[bins] : null;
    }

    public void increment(double coord, double val) {
        int bin = this.getBinNr(coord);
        if (bin < 0) {
            if (this.size - bin > this.data.length) {
                double[] tmpdata = new double[DoubleHistogram.growSize(this.data.length, this.size - bin)];
                System.arraycopy(this.data, 0, tmpdata, -bin, this.size);
                this.data = tmpdata;
            } else {
                System.arraycopy(this.data, 0, this.data, -bin, this.size);
                Arrays.fill(this.data, 0, -bin, 0.0);
            }
            this.data[0] = val;
            assert (this.data.length >= this.size - bin);
            this.offset -= bin;
            this.size -= bin;
        } else if (bin >= this.data.length) {
            double[] tmpdata = new double[DoubleHistogram.growSize(this.data.length, bin + 1)];
            System.arraycopy(this.data, 0, tmpdata, 0, this.size);
            tmpdata[bin] = val;
            this.data = tmpdata;
            this.size = bin + 1;
            this.max = Double.MAX_VALUE;
        } else {
            if (bin >= this.size) {
                this.size = bin + 1;
            }
            int n = bin;
            this.data[n] = this.data[n] + val;
        }
    }

    public double get(double coord) {
        int bin = this.getBinNr(coord);
        return bin < 0 || bin >= this.size ? 0.0 : this.data[bin];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements Histogram.Iter {
        public Iter() {
            super(DoubleHistogram.this);
        }

        public double getValue() {
            return DoubleHistogram.this.data[this.bin];
        }
    }
}

