/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.Histogram;

public class ObjHistogram<T>
extends AbstractStaticHistogram {
    Object[] data;
    Object[] special = null;
    BucketFactory<T> supplier;

    public ObjHistogram(int bins, double min, double max, BucketFactory<T> supplier) {
        super(bins, min, max);
        if (bins >= 0) {
            this.data = new Object[bins];
            if (supplier != null) {
                for (int i = 0; i < bins; ++i) {
                    this.data[i] = supplier.make();
                }
            }
        }
        this.supplier = supplier;
    }

    public T get(double coord) {
        if (coord == Double.NEGATIVE_INFINITY) {
            return this.getSpecial(0);
        }
        if (coord == Double.POSITIVE_INFINITY) {
            return this.getSpecial(1);
        }
        if (Double.isNaN(coord)) {
            return this.getSpecial(2);
        }
        int bin = this.getBinNr(coord);
        if (bin < 0) {
            if (this.size - bin > this.data.length) {
                Object[] tmpdata = new Object[ObjHistogram.growSize(this.data.length, this.size - bin)];
                System.arraycopy(this.data, 0, tmpdata, -bin, this.size);
                this.data = tmpdata;
            } else {
                System.arraycopy(this.data, 0, this.data, -bin, this.size);
            }
            for (int i = 0; i < -bin; ++i) {
                this.data[i] = this.supplier.make();
            }
            this.offset -= bin;
            this.size -= bin;
            this.max = Double.MAX_VALUE;
            return (T)this.data[0];
        }
        if (bin >= this.size) {
            if (bin >= this.data.length) {
                Object[] tmpdata = new Object[ObjHistogram.growSize(this.data.length, bin + 1)];
                System.arraycopy(this.data, 0, tmpdata, 0, this.size);
                this.data = tmpdata;
            }
            for (int i = this.size; i <= bin; ++i) {
                this.data[i] = this.supplier.make();
            }
            this.size = bin + 1;
            this.max = Double.MAX_VALUE;
            return (T)this.data[bin];
        }
        return (T)this.data[bin];
    }

    protected T getSpecial(int idx) {
        if (this.special == null) {
            this.special = new Object[]{this.supplier.make(), this.supplier.make(), this.supplier.make()};
        }
        return (T)this.special[idx];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    @FunctionalInterface
    public static interface BucketFactory<T> {
        public T make();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements Histogram.Iter {
        public Iter() {
            super(ObjHistogram.this);
        }

        public T getValue() {
            return ObjHistogram.this.data[this.bin];
        }
    }
}

