/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.range;

import de.lmu.ifi.dbs.elki.utilities.datastructures.range.IntGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntConsumer;

public class CombinedIntGenerator
implements IntGenerator {
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;
    private Collection<IntGenerator> generators;

    public CombinedIntGenerator(IntGenerator ... generators) {
        this.generators = Arrays.asList(generators);
    }

    public CombinedIntGenerator(Collection<IntGenerator> generators) {
        this.generators = generators;
    }

    @Override
    public int getMin() {
        if (this.min > this.max) {
            this.updateMinMax();
        }
        return this.min;
    }

    @Override
    public int getMax() {
        if (this.min > this.max) {
            this.updateMinMax();
        }
        return this.max;
    }

    private void updateMinMax() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        if (this.generators.isEmpty()) {
            return;
        }
        for (IntGenerator gen : this.generators) {
            int ma;
            int mi = gen.getMin();
            if (mi > (ma = gen.getMax())) continue;
            this.min = mi < this.min ? mi : this.min;
            this.max = ma > this.max ? ma : this.max;
        }
    }

    @Override
    public void forEach(IntConsumer c) {
        for (IntGenerator gen : this.generators) {
            gen.forEach(c);
        }
    }

    @Override
    public StringBuilder serializeTo(StringBuilder buf) {
        boolean first = true;
        for (IntGenerator gen : this.generators) {
            if (gen.getMin() > gen.getMax()) continue;
            if (!first) {
                buf.append(',');
            }
            first = false;
            buf = gen.serializeTo(buf);
        }
        return buf;
    }

    public String toString() {
        return this.serializeTo(new StringBuilder(1000)).toString();
    }
}

