/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.range;

import de.lmu.ifi.dbs.elki.utilities.datastructures.range.IntGenerator;
import java.util.function.IntConsumer;

public class ExponentialIntGenerator
implements IntGenerator {
    private int start;
    private int factor;
    private int end;

    public ExponentialIntGenerator(int start, int factor, int stop) {
        if (factor <= 0) {
            throw new IllegalStateException("Only positive factors are supported.");
        }
        if (start == 0) {
            throw new IllegalStateException("Starting value must not be 0.");
        }
        if (start > 0 ? stop < start : stop > start) {
            throw new IllegalStateException("Maximum must not be less than the minimum.");
        }
        this.start = start;
        this.factor = factor;
        this.end = stop;
    }

    @Override
    public int getMin() {
        return this.start > 0 ? this.start : this.end;
    }

    @Override
    public int getMax() {
        return this.start > 0 ? this.end : this.start;
    }

    @Override
    public void forEach(IntConsumer c) {
        if (this.start > 0) {
            for (int i = this.start; i <= this.end; i *= this.factor) {
                c.accept(i);
            }
        } else {
            for (int i = this.start; i >= this.end; i *= this.factor) {
                c.accept(i);
            }
        }
    }

    @Override
    public StringBuilder serializeTo(StringBuilder buf) {
        return buf.append(this.start).append(",*=").append(this.factor).append(',').append(this.end);
    }

    public String toString() {
        return this.serializeTo(new StringBuilder(100)).toString();
    }
}

