/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.range;

import de.lmu.ifi.dbs.elki.utilities.datastructures.range.IntGenerator;
import java.util.function.IntConsumer;

public class LinearIntGenerator
implements IntGenerator {
    private int start;
    private int step;
    private int stop;

    public LinearIntGenerator(int start, int step, int stop) {
        assert (start <= stop);
        if (step == 0 && start != stop) {
            throw new IllegalStateException("Step size cannot be zero.");
        }
        if (step > 0 && stop < start || step < 0 && stop > start) {
            throw new IllegalStateException("Maximum must not be less than the minimum.");
        }
        this.start = start;
        this.step = step;
        this.stop = stop;
    }

    @Override
    public int getMin() {
        return this.start <= this.stop ? this.start : this.stop;
    }

    @Override
    public int getMax() {
        return this.start <= this.stop ? this.stop : this.start;
    }

    @Override
    public void forEach(IntConsumer c) {
        if (this.start <= this.stop) {
            for (int i = this.start; i <= this.stop; i += this.step) {
                c.accept(i);
            }
        } else {
            assert (this.step < 0);
            for (int i = this.start; i >= this.stop; i += this.step) {
                c.accept(i);
            }
        }
    }

    @Override
    public StringBuilder serializeTo(StringBuilder buf) {
        return buf.append(this.start).append(",+=").append(this.step).append(',').append(this.stop);
    }

    public String toString() {
        return this.serializeTo(new StringBuilder(100)).toString();
    }
}

