/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.unionfind;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;

@Reference(authors="R. Sedgewick", title="Algorithms in C, Parts 1-4", booktitle="", bibkey="DBLP:books/daglib/0004943")
public class WeightedQuickUnionInteger {
    private int used;
    private int[] parent;
    private int[] weight = new int[51];
    private static final int INITIAL_SIZE = 51;

    public WeightedQuickUnionInteger() {
        this.parent = new int[51];
    }

    public int nextIndex(int weight) {
        if (this.used == this.parent.length) {
            int nsize = this.used + (this.used >> 1);
            this.weight = Arrays.copyOf(this.weight, nsize);
            this.parent = Arrays.copyOf(this.parent, nsize);
        }
        this.weight[this.used] = weight;
        this.parent[this.used] = this.used;
        return this.used++;
    }

    public int find(int cur) {
        assert (cur >= 0 && cur < this.parent.length);
        int p = this.parent[cur];
        while (cur != p) {
            int tmp = p;
            p = this.parent[cur] = this.parent[p];
            cur = tmp;
        }
        return cur;
    }

    public int union(int first, int second) {
        int secondComponent;
        int firstComponent = this.find(first);
        if (firstComponent == (secondComponent = this.find(second))) {
            return firstComponent;
        }
        int w1 = this.weight[firstComponent];
        int w2 = this.weight[secondComponent];
        if (w1 > w2) {
            this.parent[secondComponent] = firstComponent;
            int n = firstComponent;
            this.weight[n] = this.weight[n] + w2;
            return firstComponent;
        }
        this.parent[firstComponent] = secondComponent;
        int n = secondComponent;
        this.weight[n] = this.weight[n] + w1;
        return secondComponent;
    }

    public boolean isConnected(int first, int second) {
        return this.find(first) == this.find(second);
    }

    public IntList getRoots() {
        IntArrayList roots = new IntArrayList();
        for (int i = 0; i < this.used; ++i) {
            if (this.parent[i] != i) continue;
            roots.add(i);
        }
        return roots;
    }

    public int size() {
        return this.used;
    }
}

