/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.unionfind;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.utilities.datastructures.unionfind.UnionFind;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="R. Sedgewick", title="Algorithms in C, Parts 1-4", booktitle="", bibkey="DBLP:books/daglib/0004943")
public class WeightedQuickUnionRangeDBIDs
implements UnionFind {
    private DBIDRange ids;
    private int[] parent;
    private int[] weight;

    WeightedQuickUnionRangeDBIDs(DBIDRange ids) {
        this.ids = ids;
        this.weight = new int[ids.size()];
        Arrays.fill(this.weight, 1);
        this.parent = new int[ids.size()];
        for (int i = 0; i < this.parent.length; ++i) {
            this.parent[i] = i;
        }
    }

    @Override
    public int find(DBIDRef element) {
        int cur = this.ids.getOffset(element);
        assert (cur >= 0 && cur < this.ids.size());
        int p = this.parent[cur];
        while (cur != p) {
            int tmp = p;
            p = this.parent[cur] = this.parent[p];
            cur = tmp;
        }
        return cur;
    }

    @Override
    public int union(DBIDRef first, DBIDRef second) {
        int secondComponent;
        int firstComponent = this.find(first);
        if (firstComponent == (secondComponent = this.find(second))) {
            return firstComponent;
        }
        int w1 = this.weight[firstComponent];
        int w2 = this.weight[secondComponent];
        if (w1 > w2) {
            this.parent[secondComponent] = firstComponent;
            int n = firstComponent;
            this.weight[n] = this.weight[n] + w2;
            return firstComponent;
        }
        this.parent[firstComponent] = secondComponent;
        int n = secondComponent;
        this.weight[n] = this.weight[n] + w1;
        return secondComponent;
    }

    @Override
    public boolean isConnected(DBIDRef first, DBIDRef second) {
        return this.find(first) == this.find(second);
    }

    @Override
    public DBIDs getRoots() {
        ArrayModifiableDBIDs roots = DBIDUtil.newArray();
        DBIDArrayIter iter = this.ids.iter();
        while (iter.valid()) {
            if (this.parent[iter.getOffset()] == iter.getOffset()) {
                roots.add(iter);
            }
            iter.advance();
        }
        return roots;
    }
}

