/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.ensemble;

import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class EnsembleVotingMedian
implements EnsembleVoting {
    private double quantile = 0.5;

    public EnsembleVotingMedian(double quantile) {
        this.quantile = quantile;
    }

    @Override
    public double combine(double[] scores) {
        return this.combine(scores, scores.length);
    }

    @Override
    public double combine(double[] scores, int count) {
        return QuickSelect.quantile(scores, 0, count, this.quantile);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID QUANTILE_ID = new OptionID("ensemble.median.quantile", "Quantile to use in median voting.");
        private double quantile = 0.5;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter quantileP = (DoubleParameter)((DoubleParameter)new DoubleParameter(QUANTILE_ID, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (config.grab(quantileP)) {
                this.quantile = (Double)quantileP.getValue();
            }
        }

        @Override
        protected EnsembleVotingMedian makeInstance() {
            return new EnsembleVotingMedian(this.quantile);
        }
    }
}

