/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FixedSizeByteBufferSerializer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ByteArrayUtil {
    public static final int SIZE_BYTE = 1;
    public static final int SIZE_SHORT = 2;
    public static final int SIZE_INT = 4;
    public static final int SIZE_LONG = 8;
    public static final int SIZE_FLOAT = 4;
    public static final int SIZE_DOUBLE = 8;
    public static final ByteSerializer BYTE_SERIALIZER = new ByteSerializer();
    public static final ShortSerializer SHORT_SERIALIZER = new ShortSerializer();
    public static final IntegerSerializer INT_SERIALIZER = new IntegerSerializer();
    public static final LongSerializer LONG_SERIALIZER = new LongSerializer();
    public static final FloatSerializer FLOAT_SERIALIZER = new FloatSerializer();
    public static final DoubleSerializer DOUBLE_SERIALIZER = new DoubleSerializer();
    public static final StringSerializer STRING_SERIALIZER = new StringSerializer();
    public static final VarintSerializer VARINT_SERIALIZER = new VarintSerializer();

    private ByteArrayUtil() {
    }

    public static int writeShort(byte[] array, int offset, int v) {
        array[offset + 0] = (byte)(v >>> 8);
        array[offset + 1] = (byte)(v >>> 0);
        return 2;
    }

    public static int writeInt(byte[] array, int offset, int v) {
        array[offset + 0] = (byte)(v >>> 24);
        array[offset + 1] = (byte)(v >>> 16);
        array[offset + 2] = (byte)(v >>> 8);
        array[offset + 3] = (byte)(v >>> 0);
        return 4;
    }

    public static int writeLong(byte[] array, int offset, long v) {
        array[offset + 0] = (byte)(v >>> 56);
        array[offset + 1] = (byte)(v >>> 48);
        array[offset + 2] = (byte)(v >>> 40);
        array[offset + 3] = (byte)(v >>> 32);
        array[offset + 4] = (byte)(v >>> 24);
        array[offset + 5] = (byte)(v >>> 16);
        array[offset + 6] = (byte)(v >>> 8);
        array[offset + 7] = (byte)(v >>> 0);
        return 8;
    }

    public static int writeFloat(byte[] array, int offset, float v) {
        return ByteArrayUtil.writeInt(array, offset, Float.floatToIntBits(v));
    }

    public static int writeDouble(byte[] array, int offset, double v) {
        return ByteArrayUtil.writeLong(array, offset, Double.doubleToLongBits(v));
    }

    public static short readShort(byte[] array, int offset) {
        int b0 = array[offset + 0] & 0xFF;
        int b1 = array[offset + 1] & 0xFF;
        return (short)((b0 << 8) + (b1 << 0));
    }

    public static int readUnsignedShort(byte[] array, int offset) {
        int b0 = array[offset + 0] & 0xFF;
        int b1 = array[offset + 1] & 0xFF;
        return (b0 << 8) + (b1 << 0);
    }

    public static int readInt(byte[] array, int offset) {
        int b0 = array[offset + 0] & 0xFF;
        int b1 = array[offset + 1] & 0xFF;
        int b2 = array[offset + 2] & 0xFF;
        int b3 = array[offset + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + (b3 << 0);
    }

    public static long readLong(byte[] array, int offset) {
        long b0 = array[offset + 0];
        long b1 = array[offset + 1] & 0xFF;
        long b2 = array[offset + 2] & 0xFF;
        long b3 = array[offset + 3] & 0xFF;
        long b4 = array[offset + 4] & 0xFF;
        int b5 = array[offset + 5] & 0xFF;
        int b6 = array[offset + 6] & 0xFF;
        int b7 = array[offset + 7] & 0xFF;
        return (b0 << 56) + (b1 << 48) + (b2 << 40) + (b3 << 32) + (b4 << 24) + (long)(b5 << 16) + (long)(b6 << 8) + (long)(b7 << 0);
    }

    public static float readFloat(byte[] array, int offset) {
        return Float.intBitsToFloat(ByteArrayUtil.readInt(array, offset));
    }

    public static double readDouble(byte[] array, int offset) {
        return Double.longBitsToDouble(ByteArrayUtil.readLong(array, offset));
    }

    public static void writeSignedVarint(ByteBuffer buffer, int val) {
        ByteArrayUtil.writeUnsignedVarint(buffer, val << 1 ^ val >> 31);
    }

    public static void writeSignedVarintLong(ByteBuffer buffer, long val) {
        ByteArrayUtil.writeUnsignedVarintLong(buffer, val << 1 ^ val >> 63);
    }

    public static void writeUnsignedVarint(ByteBuffer buffer, int val) {
        while ((val & 0x7F) != val) {
            buffer.put((byte)(val & 0x7F | 0x80));
            val >>>= 7;
        }
        buffer.put((byte)(val & 0x7F));
    }

    public static void writeUnsignedVarintLong(ByteBuffer buffer, long val) {
        while ((val & 0x7FL) != val) {
            buffer.put((byte)(val & 0x7FL | 0x80L));
            val >>>= 7;
        }
        buffer.put((byte)(val & 0x7FL));
    }

    public static void writeString(ByteBuffer buffer, String s) throws IOException {
        if (s == null) {
            s = "";
        }
        STRING_SERIALIZER.toByteBuffer(buffer, s);
    }

    public static int getSignedVarintSize(int val) {
        return ByteArrayUtil.getUnsignedVarintSize(val << 1 ^ val >> 31);
    }

    public static int getUnsignedVarintSize(int obj) {
        int bytes = 1;
        while ((obj & 0x7F) != obj) {
            ++bytes;
            obj >>>= 7;
        }
        return bytes;
    }

    public static int getSignedVarintLongSize(long val) {
        return ByteArrayUtil.getUnsignedVarintLongSize(val << 1 ^ val >> 31);
    }

    public static int getUnsignedVarintLongSize(long obj) {
        int bytes = 1;
        while ((obj & 0x7FL) != obj) {
            ++bytes;
            obj >>>= 7;
        }
        return bytes;
    }

    public static int getStringSize(String s) throws IOException {
        return STRING_SERIALIZER.getByteSize(s);
    }

    public static int readSignedVarint(ByteBuffer buffer) throws IOException {
        int raw = ByteArrayUtil.readUnsignedVarint(buffer);
        return raw >>> 1 ^ -(raw & 1);
    }

    public static int readUnsignedVarint(ByteBuffer buffer) throws IOException {
        int val = 0;
        int bits = 0;
        do {
            byte data = buffer.get();
            val |= (data & 0x7F) << bits;
            if ((data & 0x80) != 0) continue;
            return val;
        } while ((bits += 7) <= 35);
        throw new IOException("Variable length quantity is too long for expected integer.");
    }

    public static long readSignedVarintLong(ByteBuffer buffer) throws IOException {
        long raw = ByteArrayUtil.readUnsignedVarintLong(buffer);
        return raw >>> 1 ^ -(raw & 1L);
    }

    public static long readUnsignedVarintLong(ByteBuffer buffer) throws IOException {
        long val = 0L;
        int bits = 0;
        do {
            byte data = buffer.get();
            val |= (long)((data & 0x7F) << bits);
            if ((data & 0x80) != 0) continue;
            return val;
        } while ((bits += 7) <= 63);
        throw new IOException("Variable length quantity is too long for expected integer.");
    }

    public static String readString(ByteBuffer buffer) throws IOException {
        return STRING_SERIALIZER.fromByteBuffer(buffer);
    }

    public static void unmapByteBuffer(final MappedByteBuffer map) {
        if (map == null) {
            return;
        }
        map.force();
        try {
            if (Runtime.class.getDeclaredMethod("version", new Class[0]) != null) {
                return;
            }
        }
        catch (NoSuchMethodException e) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Method getCleanerMethod = map.getClass().getMethod("cleaner", new Class[0]);
                        if (getCleanerMethod == null) {
                            return null;
                        }
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)map, new Object[0]);
                        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                        if (cleanMethod == null) {
                            return null;
                        }
                        cleanMethod.invoke(cleaner, new Object[0]);
                    }
                    catch (Exception e) {
                        LoggingUtil.exception(e);
                    }
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static final class VarintSerializer
    implements ByteBufferSerializer<Integer> {
        private VarintSerializer() {
        }

        @Override
        @Deprecated
        public Integer fromByteBuffer(ByteBuffer buffer) throws IOException {
            return ByteArrayUtil.readSignedVarint(buffer);
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Integer obj) {
            ByteArrayUtil.writeSignedVarint(buffer, obj);
        }

        @Override
        @Deprecated
        public int getByteSize(Integer object) {
            return ByteArrayUtil.getSignedVarintSize(object);
        }
    }

    public static final class StringSerializer
    implements ByteBufferSerializer<String> {
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder encoder = this.charset.newEncoder();
        CharsetDecoder decoder = this.charset.newDecoder();

        private StringSerializer() {
        }

        @Override
        public String fromByteBuffer(ByteBuffer buffer) throws IOException {
            int len = ByteArrayUtil.readUnsignedVarint(buffer);
            ByteBuffer subbuffer = buffer.slice();
            subbuffer.limit(len);
            CharBuffer res = this.decoder.decode(subbuffer);
            buffer.position(buffer.position() + len);
            return res.toString();
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, String obj) throws IOException {
            ByteBuffer data = this.encoder.encode(CharBuffer.wrap(obj));
            ByteArrayUtil.writeUnsignedVarint(buffer, data.remaining());
            buffer.put(data);
        }

        @Override
        public int getByteSize(String object) throws IOException {
            int len = this.encoder.encode(CharBuffer.wrap(object)).remaining();
            return ByteArrayUtil.getUnsignedVarintSize(len) + len;
        }
    }

    public static final class DoubleSerializer
    implements FixedSizeByteBufferSerializer<Double> {
        private DoubleSerializer() {
        }

        @Override
        @Deprecated
        public Double fromByteBuffer(ByteBuffer buffer) {
            return buffer.getDouble();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Double obj) {
            buffer.putDouble(obj);
        }

        @Override
        @Deprecated
        public int getByteSize(Double object) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 8;
        }
    }

    public static final class FloatSerializer
    implements FixedSizeByteBufferSerializer<Float> {
        private FloatSerializer() {
        }

        @Override
        @Deprecated
        public Float fromByteBuffer(ByteBuffer buffer) {
            return Float.valueOf(buffer.getFloat());
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Float obj) {
            buffer.putFloat(obj.floatValue());
        }

        @Override
        @Deprecated
        public int getByteSize(Float object) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 4;
        }
    }

    public static final class LongSerializer
    implements FixedSizeByteBufferSerializer<Long> {
        private LongSerializer() {
        }

        @Override
        @Deprecated
        public Long fromByteBuffer(ByteBuffer buffer) {
            return buffer.getLong();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Long obj) {
            buffer.putLong(obj);
        }

        @Override
        @Deprecated
        public int getByteSize(Long object) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 8;
        }
    }

    public static final class IntegerSerializer
    implements FixedSizeByteBufferSerializer<Integer> {
        private IntegerSerializer() {
        }

        @Override
        @Deprecated
        public Integer fromByteBuffer(ByteBuffer buffer) {
            return buffer.getInt();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Integer obj) {
            buffer.putInt(obj);
        }

        @Override
        @Deprecated
        public int getByteSize(Integer object) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 4;
        }
    }

    public static final class ShortSerializer
    implements FixedSizeByteBufferSerializer<Short> {
        private ShortSerializer() {
        }

        @Override
        @Deprecated
        public Short fromByteBuffer(ByteBuffer buffer) {
            return buffer.getShort();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Short obj) {
            buffer.putShort(obj);
        }

        @Override
        @Deprecated
        public int getByteSize(Short object) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 2;
        }
    }

    public static final class ByteSerializer
    implements FixedSizeByteBufferSerializer<Byte> {
        private ByteSerializer() {
        }

        @Override
        @Deprecated
        public Byte fromByteBuffer(ByteBuffer buffer) {
            return buffer.get();
        }

        @Override
        @Deprecated
        public void toByteBuffer(ByteBuffer buffer, Byte obj) {
            buffer.put(obj);
        }

        @Override
        @Deprecated
        public int getByteSize(Byte object) {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 1;
        }
    }
}

