/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFilenameExtension(File file) {
        return FileUtil.getFilenameExtension(file.getName());
    }

    public static String getFilenameExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        return index < 0 ? null : name.substring(index + 1).toLowerCase();
    }

    public static InputStream openSystemFile(String filename) throws FileNotFoundException {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            String resname = File.separatorChar != '/' ? filename.replace(File.separatorChar, '/') : filename;
            ClassLoader cl = FileUtil.class.getClassLoader();
            InputStream result = cl.getResourceAsStream(resname);
            if (result != null) {
                return result;
            }
            URL u = cl.getResource(resname);
            if (u == null) {
                throw e;
            }
            try {
                URLConnection conn = u.openConnection();
                conn.setUseCaches(false);
                result = conn.getInputStream();
                if (result != null) {
                    return result;
                }
            }
            catch (IOException x) {
                throw e;
            }
            throw e;
        }
    }

    public static InputStream tryGzipInput(InputStream in) throws IOException {
        if (!in.markSupported()) {
            PushbackInputStream pb = new PushbackInputStream(in, 16);
            byte[] magic = new byte[]{0, 0};
            int r = pb.read(magic);
            pb.unread(magic, 0, r);
            return magic[0] == 31 && magic[1] == -117 ? new GZIPInputStream(pb) : pb;
        }
        in.mark(16);
        boolean isgzip = (in.read() << 8 | in.read()) == 35615;
        in.reset();
        return isgzip ? new GZIPInputStream(in) : in;
    }

    public static File locateFile(String name, String basedir) {
        File f = new File(name);
        if (f.exists()) {
            return f;
        }
        if (basedir != null && (f = new File(basedir, name)).exists()) {
            return f;
        }
        String name2 = name.trim();
        if (!name.equals(name2) && (f = FileUtil.locateFile(name2, basedir)) != null) {
            return f;
        }
        name2 = name.replace('/', File.separatorChar);
        if (!name.equals(name2) && (f = FileUtil.locateFile(name2, basedir)) != null) {
            return f;
        }
        name2 = name.replace('\\', File.separatorChar);
        if (!name.equals(name2) && (f = FileUtil.locateFile(name2, basedir)) != null) {
            return f;
        }
        if (name.length() > 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"' && (f = FileUtil.locateFile(name.substring(1, name.length() - 1), basedir)) != null) {
            return f;
        }
        return null;
    }

    public static String slurp(InputStream is) throws IOException {
        int n;
        StringBuilder buf = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = is.read(b)) != -1) {
            buf.append(new String(b, 0, n));
        }
        is.close();
        return buf.toString();
    }
}

