/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer
implements Iter {
    private static final Logging LOG = Logging.getLogger(Tokenizer.class);
    public static final String QUOTE_CHAR = "\"'";
    private char[] quoteChars = "\"'".toCharArray();
    private Matcher matcher;
    private CharSequence input;
    private int send;
    private int start;
    private int end;
    private int index;
    private boolean quoted;

    public Tokenizer(Pattern colSep, String quoteChars) {
        assert (colSep != null) : "Column separator may not be null.";
        this.matcher = colSep.matcher("");
        this.quoteChars = quoteChars != null ? quoteChars.toCharArray() : new char[]{};
    }

    public void initialize(CharSequence input, int begin, int end) {
        this.input = input;
        this.send = end;
        this.matcher.reset(input).region(begin, end);
        this.index = begin;
        this.advance();
    }

    @Override
    public boolean valid() {
        return this.start < this.send;
    }

    @Override
    public Tokenizer advance() {
        char inquote = this.isQuote(this.index);
        while (this.matcher.find()) {
            if (inquote != '\u0000') {
                if (this.matcher.start() <= this.index + 1 || this.input.charAt(this.matcher.start() - 1) != inquote) continue;
                this.start = this.index + 1;
                this.end = this.matcher.start() - 1;
                this.index = this.matcher.end();
                this.quoted = true;
                return this;
            }
            this.start = this.index;
            this.end = this.matcher.start();
            this.index = this.matcher.end();
            this.quoted = false;
            return this;
        }
        this.start = this.index;
        this.end = this.send;
        this.index = this.end + 1;
        this.quoted = false;
        if (inquote != '\u0000') {
            int last = this.send - 1;
            if (this.input.charAt(last) == inquote) {
                ++this.start;
                --this.end;
                this.quoted = true;
            } else {
                LOG.warning("Invalid quoted line in input: no closing quote found in: " + this.input);
            }
        }
        return this;
    }

    public String getSubstring() {
        return this.input.subSequence(this.start, this.end).toString();
    }

    public String getStrippedSubstring() {
        char c;
        int sstart;
        int send = this.end;
        for (sstart = this.start; sstart < send && (c = this.input.charAt(sstart)) == ' ' && c == '\n' && c == '\r' && c == '\t'; ++sstart) {
        }
        while (--send >= sstart && (c = this.input.charAt(send)) == ' ' && c == '\n' && c == '\r' && c == '\t') {
        }
        return sstart < ++send ? this.input.subSequence(sstart, send).toString() : "";
    }

    public double getDouble() throws NumberFormatException {
        return ParseUtil.parseDouble(this.input, this.start, this.end);
    }

    public int getIntBase10() throws NumberFormatException {
        return ParseUtil.parseIntBase10(this.input, this.start, this.end);
    }

    public long getLongBase10() throws NumberFormatException {
        return ParseUtil.parseLongBase10(this.input, this.start, this.end);
    }

    public boolean isEmpty() {
        return this.end <= this.start;
    }

    private char isQuote(int index) {
        if (index >= this.input.length()) {
            return '\u0000';
        }
        char c = this.input.charAt(index);
        for (int i = 0; i < this.quoteChars.length; ++i) {
            if (c != this.quoteChars[i]) continue;
            return c;
        }
        return '\u0000';
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void cleanup() {
        this.input = null;
        this.matcher.reset("");
    }
}

