/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling;

import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.Parameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

public abstract class AbstractParameterizer
implements Parameterizer {
    private static final int STATE_FRESH = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_COMPLETE = 2;
    private static final int STATE_ERRORS = -1;
    private int state = 0;

    protected void makeOptions(Parameterization config) {
    }

    @Override
    public final void configure(Parameterization config) {
        this.makeOptions(config);
    }

    protected abstract Object makeInstance();

    public final Object make(Parameterization config) {
        if (this.state != 0) {
            throw new AbortException("Parameterizers may only be used once!");
        }
        this.state = 1;
        Class<?> owner = this.getClass().getDeclaringClass();
        config = config.descend(owner == null ? this : owner);
        this.makeOptions(config);
        if (!config.hasErrors()) {
            this.state = 2;
            Object ret = this.makeInstance();
            if (ret == null) {
                throw new AbortException("makeInstance() returned null!", new Throwable());
            }
            return ret;
        }
        this.state = -1;
        return null;
    }
}

