/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling;

import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ClassInstantiationException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Collection;
import java.util.List;

public final class OptionUtil {
    private OptionUtil() {
    }

    public static void formatForConsole(StringBuilder buf, int width, Collection<TrackedParameter> options) {
        for (TrackedParameter pair : options) {
            Parameter<?> par = pair.getParameter();
            OptionUtil.println(buf.append("-").append(par.getOptionID().getName()).append(' ').append(par.getSyntax()).append(FormatUtil.NEWLINE), width, OptionUtil.getFullDescription(par));
        }
    }

    public static String getFullDescription(Parameter<?> param) {
        List<ParameterConstraint<?>> constraints;
        StringBuilder description = new StringBuilder(1000).append(param.getShortDescription()).append(FormatUtil.NEWLINE);
        param.describeValues(description);
        if (!FormatUtil.endsWith(description, FormatUtil.NEWLINE)) {
            description.append(FormatUtil.NEWLINE);
        }
        if (param.hasDefaultValue()) {
            description.append("Default: ").append(param.getDefaultValueAsString()).append(FormatUtil.NEWLINE);
        }
        if ((constraints = param.getConstraints()) != null && !constraints.isEmpty()) {
            description.append(constraints.size() == 1 ? "Constraint: " : "Constraints: ").append(constraints.get(0).getDescription(param.getOptionID().getName()));
            for (int i = 1; i < constraints.size(); ++i) {
                description.append(", ").append(constraints.get(i).getDescription(param.getOptionID().getName()));
            }
            description.append(FormatUtil.NEWLINE);
        }
        return description.toString();
    }

    private static void println(StringBuilder buf, int width, String data) {
        for (String line : FormatUtil.splitAtLastBlank(data, width)) {
            buf.append(line);
            if (line.endsWith(FormatUtil.NEWLINE)) continue;
            buf.append(FormatUtil.NEWLINE);
        }
    }

    public static StringBuilder describeParameterizable(StringBuilder buf, Class<?> pcls, int width, String indent) throws ClassInstantiationException {
        Description desc;
        OptionUtil.println(buf, width, "Description for class " + pcls.getName());
        Title title = pcls.getAnnotation(Title.class);
        if (title != null && title.value() != null && !title.value().isEmpty()) {
            OptionUtil.println(buf, width, title.value());
        }
        if ((desc = pcls.getAnnotation(Description.class)) != null && desc.value() != null && !desc.value().isEmpty()) {
            OptionUtil.println(buf, width, desc.value());
        }
        for (Reference ref : (Reference[])pcls.getAnnotationsByType(Reference.class)) {
            if (!ref.prefix().isEmpty()) {
                OptionUtil.println(buf, width, ref.prefix());
            }
            OptionUtil.println(buf, width, ref.authors());
            OptionUtil.println(buf, width, ref.title());
            OptionUtil.println(buf, width, ref.booktitle());
            if (ref.url().length() <= 0) continue;
            OptionUtil.println(buf, width, ref.url());
        }
        SerializedParameterization config = new SerializedParameterization();
        TrackParameters track = new TrackParameters(config);
        Object p = ClassGenericsUtil.tryInstantiate(Object.class, pcls, track);
        Collection<TrackedParameter> options = track.getAllParameters();
        if (!options.isEmpty()) {
            OptionUtil.formatForConsole(buf, width, options);
        }
        return buf;
    }
}

