/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.AbstractNumberConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import java.util.ArrayList;
import java.util.List;

public class ListEachNumberConstraint<T>
implements ParameterConstraint<T> {
    private List<AbstractNumberConstraint> constraints;

    public ListEachNumberConstraint() {
        this.constraints = new ArrayList<AbstractNumberConstraint>();
    }

    public ListEachNumberConstraint(AbstractNumberConstraint constraint) {
        this.constraints = new ArrayList<AbstractNumberConstraint>(1);
        this.constraints.add(constraint);
    }

    public void addConstraint(AbstractNumberConstraint constraint) {
        this.constraints.add(constraint);
    }

    @Override
    public void test(T t) throws ParameterException {
        if (t instanceof int[]) {
            for (int e : (int[])t) {
                Integer n = e;
                for (AbstractNumberConstraint c : this.constraints) {
                    c.test(n);
                }
            }
        } else if (t instanceof double[]) {
            for (double e : (double[])t) {
                Double n = e;
                for (AbstractNumberConstraint c : this.constraints) {
                    c.test(n);
                }
            }
        } else {
            throw new IllegalArgumentException("ListEachConstraint currently can only be used with int[] and double[]. Please contribute patches.");
        }
    }

    @Override
    public String getDescription(String parameterName) {
        String all = "all elements of " + parameterName;
        StringBuilder b = new StringBuilder(1000);
        for (AbstractNumberConstraint c : this.constraints) {
            b.append(c.getDescription(all));
        }
        return b.toString();
    }
}

