/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import java.util.List;

public class ListSizeConstraint
implements ParameterConstraint<Object> {
    private int sizeConstraint;

    public ListSizeConstraint(int size) {
        this.sizeConstraint = size;
    }

    @Override
    public void test(Object t) throws ParameterException {
        if (t instanceof List && ((List)t).size() != this.sizeConstraint) {
            throw new WrongParameterValueException("Parameter Constraint Error.\nList parameter has not the required size. (Requested size: " + this.sizeConstraint + ", current size: " + ((List)t).size() + ").\n");
        }
        if (t instanceof int[] && ((int[])t).length != this.sizeConstraint) {
            throw new WrongParameterValueException("Parameter Constraint Error.\nList parameter has not the required size. (Requested size: " + this.sizeConstraint + ", current size: " + ((int[])t).length + ").\n");
        }
        if (t instanceof double[] && ((double[])t).length != this.sizeConstraint) {
            throw new WrongParameterValueException("Parameter Constraint Error.\nList parameter has not the required size. (Requested size: " + this.sizeConstraint + ", current size: " + ((double[])t).length + ").\n");
        }
    }

    @Override
    public String getDescription(String parameterName) {
        return "size(" + parameterName + ") = " + this.sizeConstraint;
    }
}

